<?php
/**
 * SocialGram Instance Setup
 * Initializes discussion group for a BookGram article
 */

session_start();

// Authenticate with BookGram if token is present
if (isset($_GET['bga_token'])) {
    require_once dirname(__DIR__) . '/app/core/plugin_auth.php';
    $auth = bookgram_auth_check();

    if (!$auth || !bookgram_is_editor()) {
        die('<html><body style="font-family: Arial, sans-serif; padding: 20px;">
            <h1>Authentication Required</h1>
            <p>You must be a BookGram editor to set up this plugin instance.</p>
            <p><a href="/">Return to BookGram</a></p>
            </body></html>');
    }
}

// Check if running in BookGram instance context
$instance_path = $_ENV['BOOKGRAM_INSTANCE_PATH'] ?? null;

if (!$instance_path) {
    die('<html><body style="font-family: Arial, sans-serif; padding: 20px;">
        <h1>Instance Setup</h1>
        <p>This plugin must be accessed via BookGram\'s plugin system.</p>
        <p>Please embed this plugin in an article using: <code>[plugin:socialgram id=your-instance-id]</code></p>
        <p><a href="/">Return to BookGram</a></p>
        </body></html>');
}

// Use instance-specific data directory
$data_dir = $instance_path . '/data/';
$config_file = $data_dir . 'config.json';

// Ensure data directory exists
if (!is_dir($data_dir)) {
    @mkdir($data_dir, 0755, true);
}

// Create subdirectories
@mkdir($data_dir . 'posts', 0755, true);
@mkdir($data_dir . 'uploads', 0755, true);

// Check if already set up
if (file_exists($config_file)) {
    header('Location: admin/index.php?bga_token=' . urlencode($_GET['bga_token'] ?? '') . '&instance=' . urlencode($_GET['instance'] ?? ''));
    exit;
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $group_name = trim($_POST['group_name'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $allow_anonymous = isset($_POST['allow_anonymous']);

    if (empty($group_name)) {
        $error = 'Group name is required.';
    } else {
        // Create configuration
        $config = [
            'instance_id' => $_ENV['BOOKGRAM_INSTANCE_ID'] ?? 'unknown',
            'created_at' => date('Y-m-d H:i:s'),
            'created_by' => bookgram_get_username() ?? 'system',
            'group_name' => $group_name,
            'description' => $description,
            'allow_anonymous' => $allow_anonymous,
            'max_image_size' => 2097152, // 2MB
            'max_thread_depth' => 4
        ];

        if (file_put_contents($config_file, json_encode($config, JSON_PRETTY_PRINT))) {
            $success = true;
            // Redirect to admin
            header('Location: admin/index.php?bga_token=' . urlencode($_GET['bga_token'] ?? '') . '&instance=' . urlencode($_GET['instance'] ?? ''));
            exit;
        } else {
            $error = 'Failed to save configuration.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SocialGram Setup - <?php echo htmlspecialchars($_ENV['BOOKGRAM_INSTANCE_ID'] ?? 'New Instance'); ?></title>
    <link rel="stylesheet" href="/public/css/os2-theme.css">
    <style>
        body { background: #008080; padding: 40px 20px; }
        .setup-container { max-width: 700px; margin: 0 auto; }
        .info-box { background: #e7f3ff; padding: 15px; border-left: 4px solid #007bff; margin-bottom: 20px; }
        .error { background: #ffcccc; padding: 10px; border: 2px solid #cc0000; margin: 10px 0; color: #cc0000; }
    </style>
</head>
<body>
    <div class="setup-container">
        <div class="window">
            <div class="window-title-bar">
                <span class="title">SocialGram Setup</span>
            </div>
            <div class="window-content">
                <h2>Initialize Discussion Group</h2>

                <div class="info-box">
                    <strong>Instance:</strong> <?php echo htmlspecialchars($_ENV['BOOKGRAM_INSTANCE_ID'] ?? 'unknown'); ?><br>
                    <strong>Note:</strong> This creates a discussion group for this article where readers can have threaded conversations.
                </div>

                <?php if ($error): ?>
                    <div class="error"><?php echo htmlspecialchars($error); ?></div>
                <?php endif; ?>

                <form method="POST">
                    <div class="form-group">
                        <label for="group_name"><strong>Group Name:</strong></label>
                        <input type="text" id="group_name" name="group_name" required
                               style="width: 100%; padding: 8px; margin: 5px 0;">
                    </div>

                    <div class="form-group">
                        <label for="description"><strong>Description:</strong></label>
                        <textarea id="description" name="description" rows="3"
                                  style="width: 100%; padding: 8px; margin: 5px 0;"></textarea>
                    </div>

                    <div class="form-group">
                        <label>
                            <input type="checkbox" name="allow_anonymous" value="1">
                            <strong>Allow anonymous posting</strong> (no login required)
                        </label>
                        <p style="font-size: 0.9em; color: #666; margin-left: 20px;">
                            If unchecked, users must be logged into BookGram to post.
                        </p>
                    </div>

                    <div style="margin-top: 20px;">
                        <button type="submit" class="btn">Create Discussion Group</button>
                        <a href="/" style="margin-left: 10px;">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</body>
</html>
