<?php
/**
 * JoinGram Submission Handler
 * Handles form submissions for both instance and standalone modes
 */

session_start();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die('Invalid request method.');
}

// Verify captcha
$captcha_answer = $_POST['captcha_answer'] ?? '';
$captcha_check = $_POST['captcha_check'] ?? '';

if ($captcha_answer !== $captcha_check) {
    die('<html><head><title>Captcha Failed</title><link rel="stylesheet" href="/public/css/os2-theme.css"></head>
    <body style="background: #008080; padding: 40px;">
        <div class="window" style="max-width: 600px; margin: 0 auto;">
            <div class="window-title-bar"><span class="title">Verification Failed</span></div>
            <div class="window-content">
                <h2 style="color: #cc0000;">❌ Incorrect Answer</h2>
                <p>The anti-spam verification failed. Please go back and try again.</p>
                <p><button onclick="window.close()" style="padding: 10px 20px; background: #000080; color: #fff; border: 2px outset #c0c0c0; cursor: pointer;">Close Window</button></p>
            </div>
        </div>
    </body></html>');
}

// Check if accessed via BookGram with token
if (isset($_GET['bga_token'])) {
    require_once dirname(__DIR__) . '/app/core/plugin_auth.php';
    bookgram_auth_check(); // Sets up $_ENV variables
}

// Get instance path - use instance if available, otherwise standalone
$instance_path = $_ENV['BOOKGRAM_INSTANCE_PATH'] ?? null;

// If no instance path from environment, try to get from form hidden fields
if (!$instance_path && isset($_POST['bookgram_page_uuid']) && isset($_POST['bookgram_instance_id'])) {
    $page_uuid = $_POST['bookgram_page_uuid'];
    $instance_id = $_POST['bookgram_instance_id'];

    // Construct instance path
    $base_path = dirname(__DIR__) . '/app/storage/plugin_instances';
    $instance_path = $base_path . '/' . $page_uuid . '/plugin_joingram/' . $instance_id;

    // Store in submission data
    $_ENV['BOOKGRAM_INSTANCE_ID'] = $instance_id;
}

if ($instance_path && is_dir($instance_path)) {
    // Instance mode - use instance-specific data
    $data_dir = $instance_path . '/data/';
} else {
    // Standalone mode - use local data directory
    $data_dir = __DIR__ . '/data/';
}

// Ensure data directory exists
if (!is_dir($data_dir)) {
    @mkdir($data_dir, 0755, true);
}

$submissions_file = $data_dir . 'submissions.json';

// Get new submission data (exclude captcha and context fields)
$new_submission = $_POST;
unset($new_submission['captcha_answer']);
unset($new_submission['captcha_hash']);
unset($new_submission['captcha_check']);
unset($new_submission['bookgram_page_uuid']);
unset($new_submission['bookgram_instance_id']);

// Generate unique submission ID
$new_submission['submission_id'] = 'sub_' . bin2hex(random_bytes(8)) . '_' . time();

// Get IP address
$ip_address = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
// Check for proxy headers
if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
    $ip_address = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
} elseif (!empty($_SERVER['HTTP_CLIENT_IP'])) {
    $ip_address = $_SERVER['HTTP_CLIENT_IP'];
}
$new_submission['ip_address'] = $ip_address;

$new_submission['submission_time'] = date('Y-m-d H:i:s');
$new_submission['instance_id'] = $_ENV['BOOKGRAM_INSTANCE_ID'] ?? 'standalone';

// Read existing data
$submissions = [];
if (file_exists($submissions_file)) {
    $submissions = json_decode(file_get_contents($submissions_file), true);
    if (!is_array($submissions)) {
        $submissions = [];
    }
}

// Add new submission
$submissions[] = $new_submission;

// Write data back with an exclusive lock
file_put_contents(
    $submissions_file,
    json_encode($submissions, JSON_PRETTY_PRINT),
    LOCK_EX
);

// Redirect to thank you page
header('Location: thank_you.html');
exit;
