<?php
/**
 * JoinGram Instance Setup
 *
 * This setup is called automatically when a new instance is created via BookGram.
 * It initializes the instance-specific data directory.
 *
 * Note: User authentication is handled by BookGram, so no user setup is needed.
 */

// Check if running in BookGram instance context
$instance_path = $_ENV['BOOKGRAM_INSTANCE_PATH'] ?? null;

if (!$instance_path) {
    die('<html><body style="font-family: Arial, sans-serif; padding: 20px; background: #f5f5f5;">
        <h1>Instance Setup</h1>
        <p>This plugin must be accessed via BookGram\'s plugin system.</p>
        <p>Please embed this plugin in an article using: <code>[plugin:plugin_joingram id=your-instance-id]</code></p>
        <p><a href="/">Return to BookGram</a></p>
        </body></html>');
}

// Use instance-specific data directory
$data_dir = $instance_path . '/data/';

// Ensure data directory exists
if (!is_dir($data_dir) && !mkdir($data_dir, 0755, true)) {
    die("Error: Could not create data directory. Check permissions on: " . htmlspecialchars($data_dir));
}

// Initialize submissions storage file
$submissions_file = $data_dir . 'submissions.json';
if (!file_exists($submissions_file)) {
    file_put_contents($submissions_file, json_encode([], JSON_PRETTY_PRINT));
}

// Initialize config file
$config_file = $data_dir . 'config.json';
if (!file_exists($config_file)) {
    $default_config = [
        'instance_id' => $_ENV['BOOKGRAM_INSTANCE_ID'] ?? 'unknown',
        'created_at' => date('Y-m-d H:i:s'),
        'title' => 'Application Form',
        'description' => 'Please complete the form below'
    ];
    file_put_contents($config_file, json_encode($default_config, JSON_PRETTY_PRINT));
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>JoinGram Setup Complete</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f5f5f5; padding: 20px; }
        .container { max-width: 600px; margin: 0 auto; background: white; padding: 30px; border-radius: 5px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        .success { color: #28a745; font-weight: bold; margin-bottom: 20px; }
        a { color: #007bff; text-decoration: none; }
        a:hover { text-decoration: underline; }
        .info { background: #e7f3ff; padding: 15px; border-left: 4px solid #007bff; margin-top: 20px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>✓ JoinGram Instance Setup Complete</h1>

        <p class="success">Your JoinGram instance has been initialized successfully!</p>

        <div class="info">
            <strong>Instance ID:</strong> <?php echo htmlspecialchars($_ENV['BOOKGRAM_INSTANCE_ID'] ?? 'unknown'); ?><br>
            <strong>Instance Path:</strong> <code><?php echo htmlspecialchars($instance_path); ?></code><br><br>
            <strong>Note:</strong> This is an isolated recruitment board for this BookGram article. Authentication is handled by BookGram.
        </div>

        <h2>Next Steps:</h2>
        <ul>
            <li>The public submission form is now ready at <a href="index.php">index.php</a></li>
            <li>Manage submissions via the <a href="admin/">admin panel</a> (requires BookGram editor access)</li>
            <li>Customize the form fields in the admin panel</li>
        </ul>

        <p style="margin-top: 30px;">
            <a href="index.php">→ Go to Submission Form</a><br>
            <a href="admin/">→ Go to Admin Panel</a>
        </p>
    </div>
</body>
</html>
