<?php
/**
 * JoinGram Public Submission Form
 *
 * Can run in BookGram instance mode OR standalone mode
 */

session_start();

// Check if accessed via BookGram with token
if (isset($_GET['bga_token'])) {
    require_once dirname(__DIR__) . '/app/core/plugin_auth.php';
    bookgram_auth_check(); // Sets up $_ENV variables
}

// Get instance path - use instance if available, otherwise standalone
$instance_path = $_ENV['BOOKGRAM_INSTANCE_PATH'] ?? null;

if ($instance_path) {
    // Instance mode - use instance-specific data
    $data_dir = $instance_path . '/data/';
} else {
    // Standalone mode - use local data directory
    $data_dir = __DIR__ . '/data/';
}

$survey_file = $data_dir . 'survey.json';
$config_file = $data_dir . 'config.json';

// Load config if exists
$config = file_exists($config_file) ? json_decode(file_get_contents($config_file), true) : [
    'title' => 'Application Form',
    'description' => 'Please complete the form below'
];

// Check if the survey configuration file exists
if (!file_exists($survey_file)) {
    die('<html><body style="font-family: Arial, sans-serif; padding: 40px; text-align: center;">
        <h1>Form Not Ready</h1>
        <p>The application form has not been configured yet.</p>' .
        ($instance_path ? '<p><a href="admin/">Configure Form (Admin Access Required)</a></p>' : '') .
        '</body></html>');
}

// Read and decode the survey structure
$survey_fields = json_decode(file_get_contents($survey_file), true);

// Check if JSON is valid
if (json_last_error() !== JSON_ERROR_NONE) {
     die('Error reading survey configuration. Please contact an administrator.');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($config['title']); ?></title>

    <link rel="stylesheet" href="admin/assets/os2-theme.css">
    <link rel="stylesheet" href="admin/assets/custom.css">

    <style>
        body { padding: 20px; }
        .survey-container { max-width: 700px; margin: 20px auto; }
        .form-group { margin-bottom: 20px; }
        .form-group h2 { border-bottom: 2px inset #ffffff; padding-bottom: 5px; margin-top: 10px; }
        .form-group p { font-size: 1.1em; color: #333; }
        .checkbox-option label { display: inline-block; font-weight: normal; margin-left: 5px; }
        .instance-banner { background: #e7f3ff; padding: 10px; margin-bottom: 20px; border-left: 4px solid #007bff; }
    </style>
</head>
<body>

    <div class="survey-container">
        <div class="window">
            <div class="window-title"><?php echo htmlspecialchars($config['title']); ?></div>
            <div class="window-content">

                <?php if ($instance_path): ?>
                    <div class="instance-banner">
                        <strong>📌 Instance:</strong> <?php echo htmlspecialchars($_ENV['BOOKGRAM_INSTANCE_ID'] ?? 'unknown'); ?>
                    </div>
                <?php endif; ?>

                <?php if (!empty($config['description'])): ?>
                    <p><?php echo htmlspecialchars($config['description']); ?></p>
                    <hr style="border: 0; border-top: 2px inset #ffffff; margin: 20px 0;">
                <?php endif; ?>

                <?php if (empty($survey_fields)): ?>
                    <p>The survey is currently empty. Please check back later.</p>
                <?php else: ?>
                    <form action="submit.php<?php echo isset($_GET['bga_token']) ? '?bga_token=' . urlencode($_GET['bga_token']) . '&instance=' . urlencode($_GET['instance'] ?? '') : ''; ?>" method="POST">
                        <?php foreach ($survey_fields as $field): ?>
                            <div class="form-group">
                                <?php
                                $label = isset($field['label']) ? htmlspecialchars($field['label']) : '';
                                $name = isset($field['name']) ? htmlspecialchars($field['name']) : '';
                                $text = isset($field['text']) ? htmlspecialchars($field['text']) : '';
                                $options = isset($field['options']) ? $field['options'] : [];
                                $required = (isset($field['required']) && $field['required']) ? 'required' : '';
                                ?>

                                <?php switch ($field['type']):
                                    case 'title': ?>
                                        <h2><?= $label ?></h2>
                                        <?php break; ?>

                                    <?php case 'description': ?>
                                        <p><?= $text ?></p>
                                        <?php break; ?>

                                    <?php case 'input': ?>
                                        <label for="<?= $name ?>"><?= $label ?>:</label>
                                        <input type="text" id="<?= $name ?>" name="<?= $name ?>" <?= $required ?>>
                                        <?php break; ?>

                                    <?php case 'textarea': ?>
                                        <label for="<?= $name ?>"><?= $label ?>:</label>
                                        <textarea id="<?= $name ?>" name="<?= $name ?>" <?= $required ?>></textarea>
                                        <?php break; ?>

                                    <?php case 'dropdown': ?>
                                        <label for="<?= $name ?>"><?= $label ?>:</label>
                                        <select id="<?= $name ?>" name="<?= $name ?>">
                                            <?php foreach ($options as $option): ?>
                                                <?php $opt_val = htmlspecialchars($option); ?>
                                                <option value="<?= $opt_val ?>"><?= $opt_val ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <?php break; ?>

                                    <?php case 'checkbox': ?>
                                        <label><?= $label ?>:</label>
                                        <?php foreach ($options as $key => $option): ?>
                                            <?php $opt_val = htmlspecialchars($option); ?>
                                            <?php $id = $name . '_' . $key; ?>
                                            <div class="checkbox-option">
                                                <input type="checkbox" id="<?= $id ?>" name="<?= $name ?>[]" value="<?= $opt_val ?>">
                                                <label for="<?= $id ?>"><?= $opt_val ?></label>
                                            </div>
                                        <?php endforeach; ?>
                                        <?php break; ?>

                                <?php endswitch; ?>
                            </div>
                        <?php endforeach; ?>

                        <hr style="border: 0; border-top: 2px inset #ffffff; margin: 20px 0;">
                        <button type="submit">Submit Form</button>
                    </form>
                <?php endif; ?>

            </div>
        </div>
    </div>
</body>
</html>
