<?php
/**
 * JoinGram Embed Handler
 *
 * This file is called when a JoinGram instance is embedded in an article
 * via shortcode: [plugin:plugin_joingram id=instance_id]
 */

// Get instance context from environment
$instance_path = $_ENV['BOOKGRAM_INSTANCE_PATH'] ?? null;
$instance_id = $_ENV['BOOKGRAM_INSTANCE_ID'] ?? null;
$page_uuid = $_ENV['BOOKGRAM_PAGE_UUID'] ?? null;

if (!$instance_path || !$instance_id) {
    echo '<p style="color: #cc0000;">Error: JoinGram instance context not available.</p>';
    return;
}

// Setup data directory
$data_dir = $instance_path . '/data/';
$survey_file = $data_dir . 'survey.json';
$config_file = $data_dir . 'config.json';

// Load config
$config = file_exists($config_file) ? json_decode(file_get_contents($config_file), true) : [
    'title' => 'Application Form',
    'description' => 'Please complete the form below'
];

// Check if survey exists
if (!file_exists($survey_file)) {
    // Not configured yet
    echo '<div style="padding: 20px; background: #fff3cd; border: 2px solid #ff6600; margin: 20px 0;">';
    echo '<h3>📋 ' . htmlspecialchars($config['title']) . '</h3>';
    echo '<p>This form has not been configured yet.</p>';
    echo '<p><a href="#" onclick="event.preventDefault(); openPluginAdmin(\'' . htmlspecialchars($page_uuid) . '\', \'plugin_joingram\', \'' . htmlspecialchars($instance_id) . '\', \'JoinGram\');" class="config-link" style="color: #0000ff;">Configure Form (Editor Access Required)</a></p>';
    echo '</div>';
    return;
}

// Load survey fields
$survey_fields = json_decode(file_get_contents($survey_file), true);

if (!is_array($survey_fields) || empty($survey_fields)) {
    echo '<div style="padding: 20px; background: #fff3cd; border: 2px solid #ff6600; margin: 20px 0;">';
    echo '<h3>📋 ' . htmlspecialchars($config['title']) . '</h3>';
    echo '<p>This form has no fields yet.</p>';
    echo '<p><a href="javascript:void(0);" onclick="openPluginAdmin(\'' . htmlspecialchars($page_uuid) . '\', \'plugin_joingram\', \'' . htmlspecialchars($instance_id) . '\', \'JoinGram\'); return false;" style="color: #0000ff;">Add Form Fields</a></p>';
    echo '</div>';
    return;
}

// Build absolute URL for form submission
$submit_url = '/plugin_joingram/submit.php';

// Generate simple math captcha
$num1 = rand(1, 10);
$num2 = rand(1, 10);
$captcha_answer = $num1 + $num2;
$captcha_hash = hash('sha256', $captcha_answer . session_id());

/**
 * Simple markdown-like text processor
 * Converts **bold**, *italic*, and URLs to HTML
 */
function process_markdown($text) {
    // Convert **bold** to <strong>
    $text = preg_replace('/\*\*(.+?)\*\*/', '<strong>$1</strong>', $text);

    // Convert *italic* to <em>
    $text = preg_replace('/\*(.+?)\*/', '<em>$1</em>', $text);

    // Convert URLs to clickable links that open in new window
    $text = preg_replace(
        '/(https?:\/\/[^\s<]+)/',
        '<a href="$1" target="_blank" rel="noopener noreferrer" style="color: #0000ff; text-decoration: underline;">$1</a>',
        $text
    );

    // Convert newlines to <br>
    $text = nl2br($text);

    return $text;
}
?>
<div class="joingram-embed" style="padding: 20px; background: #f5f5f5; border: 2px solid #000080; margin: 20px 0;">
    <h3 style="margin-top: 0; color: #000080; border-bottom: 2px solid #c0c0c0; padding-bottom: 10px;">
        📋 <?php echo htmlspecialchars($config['title']); ?>
    </h3>

    <?php if (!empty($config['description'])): ?>
        <p style="margin: 10px 0; color: #333;"><?php echo htmlspecialchars($config['description']); ?></p>
    <?php endif; ?>

    <form action="<?php echo $submit_url; ?>" method="POST" target="_blank" style="margin-top: 20px;" onsubmit="setTimeout(function(){ window.location.href='/'; }, 500);">
        <!-- Hidden fields for instance context -->
        <input type="hidden" name="bookgram_page_uuid" value="<?php echo htmlspecialchars($page_uuid); ?>">
        <input type="hidden" name="bookgram_instance_id" value="<?php echo htmlspecialchars($instance_id); ?>">

        <?php foreach ($survey_fields as $field): ?>
            <div style="margin-bottom: 20px;">
                <?php
                $label = isset($field['label']) ? htmlspecialchars($field['label']) : '';
                $name = isset($field['name']) ? htmlspecialchars($field['name']) : '';
                $text = isset($field['text']) ? htmlspecialchars($field['text']) : '';
                $options = isset($field['options']) ? $field['options'] : [];
                $required = (isset($field['required']) && $field['required']) ? 'required' : '';
                ?>

                <?php switch ($field['type']):
                    case 'title': ?>
                        <h4 style="margin: 15px 0 5px 0; color: #000080;"><?= process_markdown($label) ?></h4>
                        <?php break; ?>

                    <?php case 'description': ?>
                        <div style="color: #333; font-size: 1em; padding: 10px 0;"><?= process_markdown($text) ?></div>
                        <?php break; ?>

                    <?php case 'hr': ?>
                        <hr style="border: none; border-top: 2px solid #c0c0c0; margin: 20px 0;">
                        <?php break; ?>

                    <?php case 'input': ?>
                        <label style="display: block; font-weight: bold; margin-bottom: 5px;"><?= $label ?>:</label>
                        <input type="text" name="<?= $name ?>" <?= $required ?>
                               style="width: 100%; padding: 8px; border: 2px inset #c0c0c0; font-family: inherit;">
                        <?php break; ?>

                    <?php case 'textarea': ?>
                        <label style="display: block; font-weight: bold; margin-bottom: 5px;"><?= $label ?>:</label>
                        <textarea name="<?= $name ?>" <?= $required ?> rows="5"
                                  style="width: 100%; padding: 8px; border: 2px inset #c0c0c0; font-family: inherit;"></textarea>
                        <?php break; ?>

                    <?php case 'dropdown': ?>
                        <label style="display: block; font-weight: bold; margin-bottom: 5px;"><?= $label ?>:</label>
                        <select name="<?= $name ?>"
                                style="width: 100%; padding: 8px; border: 2px inset #c0c0c0; font-family: inherit;">
                            <?php foreach ($options as $option): ?>
                                <?php $opt_val = htmlspecialchars($option); ?>
                                <option value="<?= $opt_val ?>"><?= $opt_val ?></option>
                            <?php endforeach; ?>
                        </select>
                        <?php break; ?>

                    <?php case 'checkbox': ?>
                        <label style="display: block; font-weight: bold; margin-bottom: 5px;"><?= $label ?>:</label>
                        <?php foreach ($options as $key => $option): ?>
                            <?php $opt_val = htmlspecialchars($option); ?>
                            <?php $checkbox_id = $name . '_' . $key; ?>
                            <div style="margin: 5px 0;">
                                <input type="checkbox" id="<?= $checkbox_id ?>" name="<?= $name ?>[]" value="<?= $opt_val ?>">
                                <label for="<?= $checkbox_id ?>" style="display: inline; font-weight: normal; margin-left: 5px;"><?= $opt_val ?></label>
                            </div>
                        <?php endforeach; ?>
                        <?php break; ?>

                    <?php case 'radio': ?>
                        <label style="display: block; font-weight: bold; margin-bottom: 5px;"><?= $label ?>:</label>
                        <?php foreach ($options as $key => $option): ?>
                            <?php $opt_val = htmlspecialchars($option); ?>
                            <?php $radio_id = $name . '_' . $key; ?>
                            <div style="margin: 5px 0;">
                                <input type="radio" id="<?= $radio_id ?>" name="<?= $name ?>" value="<?= $opt_val ?>" <?= $required ?>>
                                <label for="<?= $radio_id ?>" style="display: inline; font-weight: normal; margin-left: 5px;"><?= $opt_val ?></label>
                            </div>
                        <?php endforeach; ?>
                        <?php break; ?>

                <?php endswitch; ?>
            </div>
        <?php endforeach; ?>

        <!-- Anti-Spam Captcha -->
        <div style="margin-top: 30px; padding: 15px; background: #fffacd; border: 2px solid #ff6600;">
            <label style="display: block; font-weight: bold; margin-bottom: 5px; color: #cc0000;">
                🤖 Anti-Spam Verification: What is <?php echo $num1; ?> + <?php echo $num2; ?>?
            </label>
            <input type="text" name="captcha_answer" required
                   style="width: 100px; padding: 8px; border: 2px inset #c0c0c0; font-family: inherit;"
                   placeholder="Answer">
            <input type="hidden" name="captcha_hash" value="<?php echo $captcha_hash; ?>">
            <input type="hidden" name="captcha_check" value="<?php echo $captcha_answer; ?>">
        </div>

        <div style="margin-top: 20px; padding-top: 15px; border-top: 2px solid #c0c0c0;">
            <button type="submit" style="padding: 10px 30px; background: #000080; color: #ffffff; border: 2px outset #c0c0c0; font-family: inherit; font-size: 1em; cursor: pointer;">
                Submit Form
            </button>
        </div>
    </form>

    <p style="margin-top: 15px; font-size: 0.85em; color: #666; border-top: 1px solid #ccc; padding-top: 10px;">
        <a href="#" onclick="event.preventDefault(); openPluginAdmin('<?php echo htmlspecialchars($page_uuid); ?>', 'plugin_joingram', '<?php echo htmlspecialchars($instance_id); ?>', 'JoinGram');" style="color: #0000ff;">
            Manage this form (Editor Access)
        </a>
    </p>
</div>
