<?php
require_once 'auth.php';
require_admin(); // Only admins can access this

$users_file = __DIR__ . '/../data/users.json';
$users = json_decode(file_get_contents($users_file), true);
$message = '';

// Handle Add User
if (isset($_POST['add_user'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];
    $role = $_POST['role'];
    
    $new_user = [
        'id' => time(), // Simple unique ID
        'username' => $username,
        'hash' => password_hash($password, PASSWORD_DEFAULT),
        'role' => $role
    ];
    
    $users[] = $new_user;
    file_put_contents($users_file, json_encode($users, JSON_PRETTY_PRINT), LOCK_EX);
    $message = "User '{$username}' added.";
}

// Handle Delete User
if (isset($_POST['delete_user'])) {
    $user_id = $_POST['user_id'];
    
    if ($user_id == $_SESSION['user_id']) {
        $message = "Error: You cannot delete yourself.";
    } else {
        $users = array_values(array_filter($users, fn($u) => $u['id'] != $user_id));
        file_put_contents($users_file, json_encode($users, JSON_PRETTY_PRINT), LOCK_EX);
        $message = "User deleted.";
    }
}

// Re-load users after any changes
$users = json_decode(file_get_contents($users_file), true);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>User Management</title>
    <link rel="stylesheet" href="assets/os2-theme.css">
    <link rel="stylesheet" href="assets/custom.css">
</head>
<body>
    <div class="admin-wrapper">
        <?php include '_sidebar.php'; // Or copy sidebar HTML here ?>
        
        <main class="content">
            <div class="window">
                <div class="window-title">User Management</div>
                <div class="window-content">
                    <?php if ($message): ?>
                        <p><strong><?= $message ?></strong></p>
                    <?php endif; ?>

                    <fieldset>
                        <legend>Add New User</legend>
                        <form method="POST">
                            <div>
                                <label>Username:</label>
                                <input type="text" name="username" required>
                            </div>
                            <div>
                                <label>Password:</label>
                                <input type="password" name="password" required>
                            </div>
                            <div>
                                <label>Role:</label>
                                <select name="role">
                                    <option value="editor">Editor</option>
                                    <option value="admin">Admin</option>
                                </select>
                            </div>
                            <button type="submit" name="add_user">Add User</button>
                        </form>
                    </fieldset>

                    <br>

                    <fieldset>
                        <legend>Existing Users</legend>
                        <table class="responses" style="width:100%">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Username</th>
                                    <th>Role</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($users as $user): ?>
                                    <tr>
                                        <td><?= $user['id'] ?></td>
                                        <td><?= htmlspecialchars($user['username']) ?></td>
                                        <td><?= $user['role'] ?></td>
                                        <td>
                                            <?php if ($user['id'] == $_SESSION['user_id']): ?>
                                                (Current User)
                                            <?php else: ?>
                                                <form method="POST" style="margin:0;">
                                                    <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
                                                    <button type="submit" name="delete_user">Delete</button>
                                                </form>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </fieldset>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
