<?php
require_once 'auth.php';
require_admin();

$css_file = __DIR__ . '/assets/custom.css';
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (is_writable($css_file)) {
        file_put_contents($css_file, $_POST['css_content']);
        $message = "CSS saved successfully!";
    } else {
        $message = "Error: File is not writable. Check permissions.";
    }
}

$current_css = file_get_contents($css_file);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Theme Editor</title>
    <link rel="stylesheet" href="assets/os2-theme.css">
    <link rel="stylesheet" href="assets/custom.css">
</head>
<body>
    <div class="admin-wrapper">
        <?php include '_sidebar.php'; // Or copy sidebar HTML here ?>
        
        <main class="content">
            <div class="window">
                <div class="window-title">Theme Editor</div>
                <div class="window-content">
                    <p>Edit the <strong>custom.css</strong> file. These styles will override the base theme.</p>
                    <?php if ($message): ?>
                        <p><strong><?= $message ?></strong></p>
                    <?php endif; ?>
                    <form method="POST">
                        <textarea name="css_content" style="width: 100%; height: 500px; font-family: monospace;">
<?= htmlspecialchars($current_css) ?>
                        </textarea>
                        <br><br>
                        <button type="submit">Save CSS</button>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
