<?php
// Common authentication and setup
require_once '_auth_header.php';

$submissions_file = $data_dir . 'submissions.json';
$survey_file = $data_dir . 'survey.json';

$submissions = file_exists($submissions_file) ? json_decode(file_get_contents($submissions_file), true) : [];
$survey = file_exists($survey_file) ? json_decode(file_get_contents($survey_file), true) : [];

// Filter survey fields to get headers (fields with a 'name' property)
$headers = array_filter($survey, fn($f) => isset($f['name']));
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>View Responses</title>
    <link rel="stylesheet" href="assets/os2-theme.css">
    <link rel="stylesheet" href="assets/custom.css">
</head>
<body>
    <div class="admin-wrapper">
        <?php include '_sidebar.php'; // Or copy sidebar HTML here ?>
        
        <main class="content">
            <div class="window">
                <div class="window-title">Applicant Responses</div>
                <div class="window-content">
                    <?php if (empty($submissions)): ?>
                        <p>No submissions have been received yet.</p>
                    <?php else: ?>
                        <a href="download.php">
                            <button>Download all as CSV</button>
                        </a>
                        <br><br>
                        <div style="overflow-x: auto;">
                            <table class="responses">
                                <thead>
                                    <tr>
                                        <th style="min-width: 150px;">Submission ID</th>
                                        <th style="min-width: 120px;">IP Address</th>
                                        <?php foreach ($headers as $field): ?>
                                            <th><?= htmlspecialchars($field['label']) ?></th>
                                        <?php endforeach; ?>
                                        <th>Submission Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach (array_reverse($submissions) as $sub): // Show newest first ?>
                                        <tr>
                                            <td style="font-family: monospace; font-size: 0.85em;">
                                                <?= htmlspecialchars($sub['submission_id'] ?? 'N/A') ?>
                                            </td>
                                            <td><?= htmlspecialchars($sub['ip_address'] ?? 'N/A') ?></td>
                                            <?php foreach ($headers as $field): ?>
                                                <td>
                                                    <?php
                                                    $name = $field['name'];
                                                    if (!isset($sub[$name])) {
                                                        echo '';
                                                    } elseif (is_array($sub[$name])) {
                                                        echo htmlspecialchars(implode(', ', $sub[$name]));
                                                    } else {
                                                        echo htmlspecialchars($sub[$name]);
                                                    }
                                                    ?>
                                                </td>
                                            <?php endforeach; ?>
                                            <td><?= htmlspecialchars($sub['submission_time']) ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </main>
    </div>

    <script>
    // Modal mode detection and parent notification
    (function() {
        const urlParams = new URLSearchParams(window.location.search);
        const isModal = urlParams.get('modal') === '1';

        if (isModal) {
            // Hide "Return to BookGram" link in modal mode
            const returnLink = document.querySelector('a[href="/"]');
            if (returnLink && returnLink.textContent.includes('Return to BookGram')) {
                returnLink.style.display = 'none';
            }

            // Add modal styling adjustments
            document.body.style.margin = '0';
            document.body.style.padding = '0';
            document.body.style.background = '#008080';
        }
    })();
    </script>
</body>
</html>
