<?php
require_once 'auth.php';

$users_file = __DIR__ . '/../data/users.json';
$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_pass = $_POST['current_password'];
    $new_pass = $_POST['new_password'];
    $confirm_pass = $_POST['confirm_password'];

    if ($new_pass !== $confirm_pass) {
        $error = "New passwords do not match.";
    } else {
        $users = json_decode(file_get_contents($users_file), true);
        $user_found = false;
        
        foreach ($users as $i => $user) {
            if ($user['id'] == $_SESSION['user_id']) {
                if (password_verify($current_pass, $user['hash'])) {
                    // Password is correct, update it
                    $users[$i]['hash'] = password_hash($new_pass, PASSWORD_DEFAULT);
                    $user_found = true;
                    break;
                } else {
                    $error = "Current password incorrect.";
                }
            }
        }

        if ($user_found) {
            file_put_contents($users_file, json_encode($users, JSON_PRETTY_PRINT), LOCK_EX);
            $message = "Password updated successfully!";
        } elseif (!$error) {
            $error = "Could not find user. Please log out and back in.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Change Password</title>
    <link rel="stylesheet" href="assets/os2-theme.css">
    <link rel="stylesheet" href="assets/custom.css">
</head>
<body>
    <div class="admin-wrapper">
        <?php include '_sidebar.php'; // Or copy sidebar HTML here ?>
        
        <main class="content">
            <div class="window">
                <div class="window-title">Change Your Password</div>
                <div class="window-content">
                    <?php if ($message): ?><p style="color: green;"><?= $message ?></p><?php endif; ?>
                    <?php if ($error): ?><p style="color: red;"><?= $error ?></p><?php endif; ?>

                    <form method="POST">
                        <div>
                            <label>Current Password:</label>
                            <input type="password" name="current_password" required>
                        </div>
                        <div>
                            <label>New Password:</label>
                            <input type="password" name="new_password" required>
                        </div>
                        <div>
                            <label>Confirm New Password:</label>
                            <input type="password" name="confirm_password" required>
                        </div>
                        <button type="submit">Update Password</button>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
