<?php
session_start();
$users_file = __DIR__ . '/../data/users.json';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    if (!file_exists($users_file)) {
        header('Location: index.php?error=1');
        exit;
    }

    $users = json_decode(file_get_contents($users_file), true);
    $logged_in = false;

    foreach ($users as $user) {
        if ($user['username'] === $username && password_verify($password, $user['hash'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['role'] = $user['role'];
            $logged_in = true;
            break;
        }
    }

    if ($logged_in) {
        header('Location: dashboard.php');
        exit;
    } else {
        header('Location: index.php?error=1');
        exit;
    }
} else {
    header('Location: index.php');
    exit;
}
?>
