<?php
// Common authentication and setup
require_once '_auth_header.php';

$submissions_file = $data_dir . 'submissions.json';
$survey_file = $data_dir . 'survey.json';

if (!file_exists($submissions_file) || !file_exists($survey_file)) {
    die('No data available.');
}

$submissions = json_decode(file_get_contents($submissions_file), true);
$survey = json_decode(file_get_contents($survey_file), true);

// Set headers to force download
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="responses-' . date('Y-m-d') . '.csv"');

$output = fopen('php://output', 'w');

// Create header row from survey.json
$headers = ['Submission ID', 'IP Address'];
foreach ($survey as $field) {
    if (isset($field['name'])) {
        $headers[] = $field['label']; // Use label for header
    }
}
$headers[] = 'Submission Time';
fputcsv($output, $headers);

// Create data rows
$field_names = array_column(array_filter($survey, fn($f) => isset($f['name'])), 'name');

foreach ($submissions as $sub) {
    $row = [
        $sub['submission_id'] ?? 'N/A',
        $sub['ip_address'] ?? 'N/A'
    ];
    foreach ($field_names as $name) {
        if (!isset($sub[$name])) {
            $row[] = ''; // Empty cell if no data
        } elseif (is_array($sub[$name])) {
            $row[] = implode('; ', $sub[$name]); // Join checkbox arrays
        } else {
            $row[] = $sub[$name];
        }
    }
    $row[] = $sub['submission_time'];
    fputcsv($output, $row);
}

fclose($output);
exit;
