<?php
// Common authentication and setup
require_once '_auth_header.php';

$config_file = $data_dir . 'config.json';
$save_message = '';

// Handle configuration save
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_config'])) {
    $new_config = [
        'title' => trim($_POST['title'] ?? 'Recruitment Application'),
        'description' => trim($_POST['description'] ?? '')
    ];

    file_put_contents($config_file, json_encode($new_config, JSON_PRETTY_PRINT), LOCK_EX);
    $save_message = 'Configuration saved successfully!';
}

// Load current config
$config = file_exists($config_file) ? json_decode(file_get_contents($config_file), true) : [
    'title' => 'Application Form',
    'description' => 'Please complete the form below'
];

// Load submissions count
$submissions_file = $instance_path . '/data/submissions.json';
$submissions = file_exists($submissions_file) ? json_decode(file_get_contents($submissions_file), true) : [];
$submission_count = count($submissions);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Dashboard - JoinGram</title>
    <link rel="stylesheet" href="assets/os2-theme.css">
    <link rel="stylesheet" href="assets/custom.css">
</head>
<body>
    <div class="admin-wrapper">

        <?php include '_sidebar.php'; ?>

        <main class="content">
            <div class="window">
                <div class="window-title">Dashboard</div>
                <div class="window-content">
                    <h2>Welcome to JoinGram</h2>

                    <div style="background: #e7f3ff; padding: 15px; border-left: 4px solid #007bff; margin-bottom: 20px;">
                        <strong>Instance:</strong> <?php echo htmlspecialchars($instance_id); ?><br>
                        <strong>Managed by:</strong> <?php echo htmlspecialchars(bookgram_get_username()); ?> (<?php echo bookgram_is_admin() ? 'Admin' : 'Editor'; ?>)
                    </div>

                    <?php if ($save_message): ?>
                        <div style="background: #d4edda; padding: 15px; border-left: 4px solid #28a745; margin-bottom: 20px; color: #155724;">
                            ✓ <?php echo htmlspecialchars($save_message); ?>
                        </div>
                    <?php endif; ?>

                    <h3>Form Configuration</h3>
                    <form method="POST" style="background: #f5f5f5; padding: 20px; border: 2px solid #c0c0c0; margin-bottom: 20px;">
                        <div style="margin-bottom: 15px;">
                            <label for="title" style="display: block; font-weight: bold; margin-bottom: 5px;">Form Title:</label>
                            <input type="text" id="title" name="title" value="<?php echo htmlspecialchars($config['title']); ?>"
                                   required style="width: 100%; padding: 8px; border: 2px inset #c0c0c0; font-family: inherit; max-width: 500px;">
                            <small style="color: #666;">This appears as the main heading on your public form</small>
                        </div>

                        <div style="margin-bottom: 15px;">
                            <label for="description" style="display: block; font-weight: bold; margin-bottom: 5px;">Form Description:</label>
                            <textarea id="description" name="description" rows="3"
                                      style="width: 100%; padding: 8px; border: 2px inset #c0c0c0; font-family: inherit; max-width: 500px;"><?php echo htmlspecialchars($config['description']); ?></textarea>
                            <small style="color: #666;">Optional description text shown below the title</small>
                        </div>

                        <button type="submit" name="save_config" value="1"
                                style="padding: 10px 20px; background: #000080; color: #ffffff; border: 2px outset #c0c0c0; font-family: inherit; cursor: pointer;">
                            Save Configuration
                        </button>
                    </form>

                    <h3>Quick Stats</h3>
                    <ul>
                        <li><strong>Total Submissions:</strong> <?php echo $submission_count; ?></li>
                    </ul>

                    <h3>Management Tools</h3>
                    <p>Use the navigation on the left to manage your form:</p>
                    <ul>
                        <li><strong>Form Builder:</strong> Create and edit the form questions and fields</li>
                        <li><strong>View Responses:</strong> See all submissions and download as CSV</li>
                        <li><strong>Change Log:</strong> View history of form modifications</li>
                    </ul>

                    <p style="margin-top: 20px;">
                        <a href="/" style="color: #007bff;">← Return to BookGram</a>
                    </p>
                </div>
            </div>
        </main>
    </div>

    <script>
    // Modal mode detection and parent notification
    (function() {
        const urlParams = new URLSearchParams(window.location.search);
        const isModal = urlParams.get('modal') === '1';

        if (isModal) {
            // Hide "Return to BookGram" link in modal mode
            const returnLink = document.querySelector('a[href="/"]');
            if (returnLink && returnLink.textContent.includes('Return to BookGram')) {
                returnLink.style.display = 'none';
            }

            // Add modal styling adjustments
            document.body.style.margin = '0';
            document.body.style.padding = '0';
            document.body.style.background = '#008080';
        }
    })();
    </script>
</body>
</html>
