<?php
// Common authentication and setup
require_once '_auth_header.php';

$change_log_file = $data_dir . 'change_log.json';

// Load change log
$change_log = file_exists($change_log_file) ? json_decode(file_get_contents($change_log_file), true) : [];
if (!is_array($change_log)) {
    $change_log = [];
}

// Reverse to show newest first
$change_log = array_reverse($change_log);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Form Change Log</title>
    <link rel="stylesheet" href="assets/os2-theme.css">
    <link rel="stylesheet" href="assets/custom.css">
    <style>
        .change-entry {
            border: 2px solid #c0c0c0;
            background: #ffffff;
            padding: 15px;
            margin-bottom: 15px;
        }
        .change-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding-bottom: 10px;
            border-bottom: 1px solid #c0c0c0;
            margin-bottom: 10px;
        }
        .change-id {
            font-family: monospace;
            font-size: 0.9em;
            color: #666;
        }
        .change-user {
            font-weight: bold;
            color: #000080;
        }
        .change-timestamp {
            color: #666;
            font-size: 0.9em;
        }
        .change-summary {
            padding: 10px;
            background: #f5f5f5;
            border-left: 4px solid #000080;
            margin-top: 10px;
        }
        .stats {
            display: flex;
            gap: 20px;
            margin-top: 10px;
            font-size: 0.9em;
        }
        .stat-item {
            color: #333;
        }
    </style>
</head>
<body>
    <div class="admin-wrapper">
        <?php include '_sidebar.php'; ?>

        <main class="content">
            <div class="window">
                <div class="window-title">Form Change Log</div>
                <div class="window-content">
                    <?php if (empty($change_log)): ?>
                        <p>No changes have been logged yet.</p>
                    <?php else: ?>
                        <p style="margin-bottom: 20px;">Showing <?= count($change_log) ?> most recent change<?= count($change_log) !== 1 ? 's' : '' ?>:</p>

                        <?php foreach ($change_log as $change): ?>
                            <div class="change-entry">
                                <div class="change-header">
                                    <div>
                                        <span class="change-user"><?= htmlspecialchars($change['user']) ?></span>
                                        <span class="change-timestamp"><?= htmlspecialchars($change['timestamp']) ?></span>
                                    </div>
                                    <div class="change-id">
                                        <?= htmlspecialchars($change['change_id']) ?>
                                    </div>
                                </div>

                                <div class="change-summary">
                                    <?= htmlspecialchars($change['changes_summary']) ?>
                                </div>

                                <div class="stats">
                                    <div class="stat-item">
                                        <strong>Before:</strong> <?= $change['old_field_count'] ?> field<?= $change['old_field_count'] !== 1 ? 's' : '' ?>
                                    </div>
                                    <div class="stat-item">
                                        <strong>After:</strong> <?= $change['new_field_count'] ?> field<?= $change['new_field_count'] !== 1 ? 's' : '' ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </main>
    </div>

    <script>
    // Modal mode detection and parent notification
    (function() {
        const urlParams = new URLSearchParams(window.location.search);
        const isModal = urlParams.get('modal') === '1';

        if (isModal) {
            // Hide "Return to BookGram" link in modal mode
            const returnLink = document.querySelector('a[href="/"]');
            if (returnLink && returnLink.textContent.includes('Return to BookGram')) {
                returnLink.style.display = 'none';
            }

            // Add modal styling adjustments
            document.body.style.margin = '0';
            document.body.style.padding = '0';
            document.body.style.background = '#008080';
        }
    })();
    </script>
</body>
</html>
