<?php
/**
 * Shared sidebar for JoinGram admin
 * Uses BookGram authentication
 */

// Get URL params for navigation
$token = $_GET['bga_token'] ?? '';
$instance = $_GET['instance'] ?? '';
$url_params = $token ? "?bga_token=" . urlencode($token) . "&instance=" . urlencode($instance) : '';

// Get the current page to set active link
$currentPage = basename($_SERVER['SCRIPT_NAME']);
?>
<div class="sidebar">
    <h3>JoinGram Admin</h3>
    <nav>
        <a href="dashboard.php<?php echo $url_params; ?>" class="<?= ($currentPage == 'dashboard.php') ? 'active' : '' ?>">Dashboard</a>
        <a href="form-builder.php<?php echo $url_params; ?>" class="<?= ($currentPage == 'form-builder.php') ? 'active' : '' ?>">Form Builder</a>
        <a href="responses.php<?php echo $url_params; ?>" class="<?= ($currentPage == 'responses.php') ? 'active' : '' ?>">View Responses</a>
        <a href="changelog.php<?php echo $url_params; ?>" class="<?= ($currentPage == 'changelog.php') ? 'active' : '' ?>">Change Log</a>
        <a href="../index.php<?php echo $url_params; ?>">View Public Form</a>
    </nav>
    <div class="user-info">
        Logged in as: <strong><?php echo htmlspecialchars(bookgram_get_username() ?? 'User'); ?></strong> (<?php echo bookgram_is_admin() ? 'Admin' : 'Editor'; ?>)
        <br>
        <a href="/">Return to BookGram</a>
    </div>
</div>
