<?php
/**
 * Common authentication header for all JoinGram admin pages
 * Include this at the top of every admin page
 */

// Use BookGram authentication
require_once dirname(dirname(__DIR__)) . '/app/core/plugin_auth.php';
$auth = bookgram_auth_check();
bookgram_require_editor();

// Get instance context
$instance_id = bookgram_get_instance_id();
$instance_path = bookgram_get_instance_path();

// Validate instance path
if (!$instance_path || !is_dir($instance_path)) {
    die('<html><body><h1>Error</h1><p>Instance path not found. Please access via BookGram plugin-admin route.</p></body></html>');
}

// Build URL parameters for navigation
$token = $_GET['bga_token'] ?? '';
$instance_param = $_GET['instance'] ?? '';
$url_params = $token ? "?bga_token=" . urlencode($token) . "&instance=" . urlencode($instance_param) : '';

// Ensure data directory exists
$data_dir = $instance_path . '/data/';
if (!is_dir($data_dir)) {
    @mkdir($data_dir, 0755, true);
}
