<?php
/**
 * ChatGram API - Get Online Users
 * Returns list of currently online users
 */

session_start();
header('Content-Type: application/json');

// Get parameters
$instance_id = $_GET['instance_id'] ?? null;

if (!$instance_id) {
    echo json_encode(['success' => false, 'error' => 'Missing instance_id']);
    exit;
}

// Find instance path
function find_instance_path($instance_id) {
    $base = dirname(__DIR__, 2) . '/app/storage/plugin_instances/';

    if (!is_dir($base)) {
        return null;
    }

    $page_dirs = glob($base . '*', GLOB_ONLYDIR);
    foreach ($page_dirs as $page_dir) {
        $plugin_path = $page_dir . '/plugin_chatgram/' . $instance_id;
        if (is_dir($plugin_path)) {
            return $plugin_path;
        }
    }

    return null;
}

$instance_path = find_instance_path($instance_id);

if (!$instance_path) {
    echo json_encode(['success' => false, 'error' => 'Instance not found']);
    exit;
}

// Load storage library
require_once dirname(__DIR__) . '/lib/ChatStorage.php';
$storage = new ChatStorage($instance_path);

// Get online users
$users = $storage->loadOnlineUsers();

// DEBUG: Log what we're returning
error_log('[ChatGram Users] Loaded ' . count($users) . ' online users');
error_log('[ChatGram Users] Users data: ' . json_encode($users));

// Return response
echo json_encode([
    'success' => true,
    'users' => $users,
    'count' => count($users)
]);
