<?php
/**
 * ChatGram API - Get Messages
 * Returns new public messages since timestamp
 */

session_start();
header('Content-Type: application/json');

// Get parameters
$instance_id = $_GET['instance_id'] ?? null;
$since_timestamp = intval($_GET['since_timestamp'] ?? 0);
$limit = intval($_GET['limit'] ?? 50);

if (!$instance_id) {
    echo json_encode(['success' => false, 'error' => 'Missing instance_id']);
    exit;
}

// Find instance path
function find_instance_path($instance_id) {
    $base = dirname(__DIR__, 2) . '/app/storage/plugin_instances/';

    if (!is_dir($base)) {
        return null;
    }

    // Iterate through page UUIDs
    $page_dirs = glob($base . '*', GLOB_ONLYDIR);
    foreach ($page_dirs as $page_dir) {
        $plugin_path = $page_dir . '/plugin_chatgram/' . $instance_id;
        if (is_dir($plugin_path)) {
            return $plugin_path;
        }
    }

    return null;
}

$instance_path = find_instance_path($instance_id);

if (!$instance_path) {
    echo json_encode(['success' => false, 'error' => 'Instance not found']);
    exit;
}

// Load storage library
require_once dirname(__DIR__) . '/lib/ChatStorage.php';
$storage = new ChatStorage($instance_path);

// Get messages since timestamp
$messages = $storage->getMessagesSince($since_timestamp, $limit);

// Return response
echo json_encode([
    'success' => true,
    'messages' => $messages,
    'server_time' => time(),
    'has_more' => false
]);
