<?php
/**
 * ChatGram API - Guest Setup
 * Handles guest name validation and session creation
 */

session_start();
header('Content-Type: application/json');

// Only allow POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit;
}

// Get parameters
$guest_name = trim($_POST['guest_name'] ?? '');
$instance_id = $_POST['instance_id'] ?? null;

if (!$guest_name || !$instance_id) {
    echo json_encode(['success' => false, 'error' => 'Missing required parameters']);
    exit;
}

// Load GuestManager
require_once dirname(__DIR__) . '/lib/GuestManager.php';
require_once dirname(__DIR__) . '/lib/ChatStorage.php';

// Validate guest name
$validated_name = GuestManager::validateGuestName($guest_name);

if ($validated_name === false) {
    echo json_encode(['success' => false, 'error' => 'Name is not available or contains invalid characters']);
    exit;
}

// Find instance path
function find_instance_path($instance_id) {
    $base = dirname(__DIR__, 2) . '/app/storage/plugin_instances/';
    if (!is_dir($base)) {
        return null;
    }
    $page_dirs = glob($base . '*', GLOB_ONLYDIR);
    foreach ($page_dirs as $page_dir) {
        $plugin_path = $page_dir . '/plugin_chatgram/' . $instance_id;
        if (is_dir($plugin_path)) {
            return $plugin_path;
        }
    }
    return null;
}

$instance_path = find_instance_path($instance_id);
if (!$instance_path) {
    echo json_encode(['success' => false, 'error' => 'Instance not found']);
    exit;
}

// Create guest session
$guest_session = GuestManager::createGuestSession($validated_name, $instance_id);

// Save to storage
$storage = new ChatStorage($instance_path);
$storage->addGuestSession(
    $guest_session['guest_id'],
    $validated_name,
    $guest_session['session_id'],
    $instance_id
);

echo json_encode([
    'success' => true,
    'guest_id' => $guest_session['guest_id'],
    'display_name' => $validated_name
]);
