<?php
/**
 * PlayList Plugin Setup
 * Initializes instance data directories and default configuration
 */

$instance_path = $_ENV['BOOKGRAM_INSTANCE_PATH'] ?? null;

if (!$instance_path) {
    die('Error: Instance path not provided.');
}

$data_dir = $instance_path . '/data/';
$config_file = $data_dir . 'config.json';
$playlists_file = $data_dir . 'playlists.json';
$uploads_dir = $data_dir . 'uploads/';

// Create data directory
if (!is_dir($data_dir)) {
    mkdir($data_dir, 0755, true);
}

// Create uploads directory
if (!is_dir($uploads_dir)) {
    mkdir($uploads_dir, 0755, true);
}

// Create default config
if (!file_exists($config_file)) {
    $default_config = [
        'player_name' => 'Playlist Player',
        'description' => 'Audio/Video playlist player',
        'source_type' => 'none', // none, url, file, youtube, odysee
        'source_value' => '',
        'auto_play' => false,
        'show_metadata' => true,
        'allow_speed_control' => true,
        'cors_proxy' => 'https://cors-anywhere.herokuapp.com/',
        'created_at' => date('Y-m-d H:i:s')
    ];
    file_put_contents($config_file, json_encode($default_config, JSON_PRETTY_PRINT));
}

// Create empty playlists file
if (!file_exists($playlists_file)) {
    file_put_contents($playlists_file, json_encode([], JSON_PRETTY_PRINT));
}
