# PlayList Plugin for BookGram

Audio/Video playlist player supporting multiple sources including M3U/PLS files, YouTube, Odysee, and direct media links.

## Features

- **Multiple Source Types:**
  - M3U/M3U8 playlists (local files or URLs)
  - PLS playlists (local files or URLs)
  - Direct audio/video URLs (MP3, MP4, etc.)
  - YouTube videos
  - Odysee videos

- **Player Features:**
  - Play, pause, previous, next controls
  - Adjustable playback speed
  - Metadata display
  - Auto-play option
  - HLS streaming support (for .m3u8 files)
  - Track list navigation

- **Per-Article Instances:**
  - Each article can have its own playlist configuration
  - Isolated data storage per instance
  - Secure admin configuration interface

## Usage

### 1. Add PlayList to an Article

In the article editor, insert the plugin shortcode:

```markdown
[plugin:PlayList id=myplaylist]
```

Replace `myplaylist` with a unique ID for this playlist instance.

### 2. Configure the Playlist

After saving the article, click the "Configure Playlist" link to access the admin panel.

### Configuration Options

#### Basic Settings

- **Player Name:** Display name for the playlist player
- **Description:** Optional description shown above the player

#### Source Type Options

##### Direct URL (M3U/PLS/Media File)
Enter a direct URL to:
- M3U playlist: `https://example.com/stream.m3u`
- M3U8 HLS stream: `https://example.com/stream.m3u8`
- PLS playlist: `https://example.com/playlist.pls`
- Direct audio: `https://example.com/audio.mp3`
- Direct video: `https://example.com/video.mp4`

##### Upload Playlist File
Upload a local M3U, M3U8, or PLS file (max 5MB).

##### YouTube Video/Playlist
Enter a YouTube video or playlist URL:
- **Single video:** `https://www.youtube.com/watch?v=VIDEO_ID`
- **Short format:** `https://youtu.be/VIDEO_ID`
- **Playlist:** `https://www.youtube.com/playlist?list=PLAYLIST_ID`
- **Video in playlist:** `https://www.youtube.com/watch?v=VIDEO_ID&list=PLAYLIST_ID`

##### Odysee Video
Enter the Odysee embed URL:
1. Go to the video on Odysee
2. Click "Share" → "Embed"
3. Copy the embed URL (e.g., `https://odysee.com/$/embed/@channel:a/video:b`)

#### Player Options

- **Auto-play on load:** Start playing automatically when page loads
- **Show metadata/track info:** Display track information below player
- **Allow playback speed control:** Enable speed adjustment buttons

#### Advanced Settings

- **CORS Proxy:** Proxy URL for loading external playlists (default: cors-anywhere.herokuapp.com)

## Examples

### Example 1: Internet Radio Station

```markdown
My favorite radio station:

[plugin:PlayList id=radio]
```

Configuration:
- Source Type: Direct URL
- URL: `https://stream.example.com/radio.m3u8`
- Auto-play: Enabled

### Example 2: Podcast Episode

```markdown
Latest podcast episode:

[plugin:PlayList id=podcast]
```

Configuration:
- Source Type: Direct URL
- URL: `https://example.com/podcast-ep123.mp3`
- Show metadata: Enabled

### Example 3: YouTube Video

```markdown
Check out this tutorial:

[plugin:PlayList id=tutorial]
```

Configuration:
- Source Type: YouTube Video
- URL: `https://www.youtube.com/watch?v=dQw4w9WgXcQ`

### Example 4: Music Album

```markdown
My album playlist:

[plugin:PlayList id=album]
```

Configuration:
- Source Type: Upload Playlist File
- File: Upload `album.m3u` containing track URLs

## Supported Playlist Formats

### M3U/M3U8 Format

```
#EXTM3U
#EXTINF:180,Artist - Song Title
https://example.com/track1.mp3
#EXTINF:200,Artist - Another Song
https://example.com/track2.mp3
```

### PLS Format

```
[playlist]
NumberOfEntries=2
File1=https://example.com/track1.mp3
Title1=Artist - Song Title
Length1=180
File2=https://example.com/track2.mp3
Title2=Artist - Another Song
Length2=200
```

## Technical Details

- **HLS Support:** Uses HLS.js for adaptive streaming
- **CORS Handling:** Configurable CORS proxy for external playlists
- **YouTube API:** Uses YouTube IFrame Player API
- **File Size Limit:** 5MB for uploaded playlist files
- **Supported Extensions:** .m3u, .m3u8, .pls

## Troubleshooting

### Playlist Won't Load

- Check that the URL is accessible
- Verify CORS headers if loading from external source
- Try using the CORS proxy
- Check browser console for error messages

### YouTube Video Not Playing

- Verify the video URL is correct
- Ensure the video is not private or restricted
- Check that YouTube IFrame API is loading

### Audio Files Won't Play

- Verify browser supports the audio format
- Check that file URLs are direct links to media files
- Test the URL directly in browser

## Browser Compatibility

- Chrome/Edge: Full support
- Firefox: Full support
- Safari: Full support (with some HLS limitations)
- Mobile browsers: Supported (with touch controls)

## Security

- All playlist configurations are isolated per instance
- BookGram authentication required for admin access
- File uploads are validated for type and size
- XSS protection through proper escaping

## Version History

### 2.0.2 (Current)
- Added YouTube metadata display support
- Shows video title, channel name, playlist position, and duration
- Metadata updates automatically when playlist videos change
- Enhanced YouTube player event handling

### 2.0.1
- Added YouTube playlist support
- Support for playlist URLs, video URLs, and mixed URLs
- Updated documentation with playlist examples

### 2.0.0
- Complete refactor as BookGram PHP plugin
- Added YouTube video support
- Added Odysee support
- Added file upload capability
- Per-article instance isolation
- Integrated admin configuration

### 1.0.0 (Legacy)
- Original standalone HTML player
- M3U/PLS support only

## Future Enhancements

- [ ] Vimeo support
- [ ] Spotify embed support
- [ ] Visual waveform display
- [ ] Shuffle and repeat modes
- [ ] Download playlist option
- [ ] Share playlist feature
