# Quick Start Guide - HTML Embeds

## Basic Usage

### Step 1: Add your HTML file
Place your HTML file in the `/embeds/` directory:
```
/embeds/
└── myfile.html
```

### Step 2: Use the shortcode in your page
Edit your BookGram page and add:
```
[html:myfile.html]
```

That's it! Your HTML file (with JavaScript) will be embedded in an iframe.

## Examples

### Embed the Atom Diagram Tool
```
[html:AtomDiagramTool_Speed.html]
```

### Embed with Custom Size
```
[html:test-embed.html width=800 height=400]
```

### Multiple Embeds on One Page
```markdown
# My Page with Multiple Embeds

Here's the first visualization:
[html:AtomDiagramTool_Speed.html]

And here's a test embed:
[html:test-embed.html width=600 height=300]

Pretty cool!
```

### Center an Embed
```
[html:test-embed.html class=centered-embed]
```

## Available Files

Currently available in `/embeds/`:
- `AtomDiagramTool_Speed.html` - 3D heptagram projection visualization
- `test-embed.html` - Simple test with interactive buttons

## Common Parameters

- `width=800` - Set width in pixels (or use `width=80%` for percentage)
- `height=400` - Set height in pixels
- `class=centered-embed` - Add custom CSS class
- `sandbox=strict` - Use stricter security (blocks same-origin access)

## Need Help?

See the full documentation in `README.md` in this directory.
