# BookGram

**Version 10.02.0** - A retro-styled, file-based content management system with an IBM OS/2 Warp 3 aesthetic.

## Overview

BookGram is a lightweight, file-based CMS designed for simplicity and nostalgia. It features a distinctive retro IBM OS/2 Warp 3 interface while providing modern functionality like markdown support, user authentication, and an extensible plugin system.

## Features

### Core Features
- **File-Based Storage**: No database required - all content stored as JSON files
- **Markdown Support**: Write content using Markdown (via Parsedown)
- **User Authentication**: Admin and Editor role system
- **Page Organization**: Directory/folder-based content structure
- **Revision History**: Track and revert page changes
- **Privacy Controls**: Private pages with optional password protection
- **Search**: Full-text search across all public pages
- **RSS Feed**: Automatic RSS generation
- **Profile Pages**: User profile system
- **Analytics**: Page view tracking (total and unique)
- **Responsive Design**: Mobile-friendly with retro aesthetics
- **Movable Launchpad**: Draggable navigation menu

### Plugins

#### ChatGram (Live Chat)
Real-time IRC-style chat plugin with:
- General chat pool for all users
- Private 1-on-1 messaging
- Guest access with custom names/handles
- User presence indicators
- System-wide enable/disable toggle
- Access modes: login-only or login + guest
- 3-second AJAX polling for real-time updates
- Rate limiting and spam prevention

#### JoinGram (Survey/Forms)
Flexible form builder and submission system with:
- Drag-and-drop form builder
- Multiple field types: text input, textarea, dropdown, checkboxes, radio buttons, titles, descriptions, horizontal lines
- Markdown support in titles and descriptions
- Unique submission IDs and IP tracking
- Form change logging and history
- CSV export of responses
- Customizable form titles and descriptions
- Anti-spam captcha
- Instance-based isolation

#### SocialGram (Social Feed)
Social posting and commenting system (included in base installation)

#### PlayList
Audio playlist manager (included in base installation)

## System Requirements

- PHP 7.4 or higher
- Web server (Apache, Nginx, etc.)
- Write permissions for data directories

## Installation

1. Upload files to your web server
2. Ensure `app/storage/` directory is writable
3. Access the site in your browser
4. Default admin credentials will be created on first run

## Directory Structure

```
bookgram/
├── app/
│   ├── core/           # Core functions and utilities
│   └── storage/        # User data, pages, config
├── public/             # Public assets (CSS, JS, images)
├── templates/          # Page templates
├── plugin_chatgram/    # ChatGram live chat plugin
├── plugin_joingram/    # JoinGram form/survey plugin
├── plugin_socialgram/  # SocialGram social feed plugin
├── plugin_PlayList/    # PlayList audio manager plugin
├── index.php           # Main entry point
├── CHANGELOG.md        # Version history
└── README.md           # This file
```

## Configuration

Configuration is managed through:
- `app/storage/config.json` - System-wide settings
- `app/storage/users.json` - User accounts
- Individual page JSON files in `app/storage/pages/`

## Plugin System

BookGram supports instance-based plugins that can be embedded in pages using shortcodes:

```
[plugin:plugin_name id=instance-id]
```

Plugins support:
- Multiple instances per plugin
- Instance-specific data isolation
- Admin panels for configuration
- Modal-based management interface

## Version History

See [CHANGELOG.md](CHANGELOG.md) for detailed version history.

### Latest: 10.02.0 (2025-12-20)

**ChatGram Updates:**
- Fixed authentication issues for logged-in users
- Added Unicode avatar fallback (👤)
- Enhanced debug logging

**JoinGram Updates:**
- Markdown rendering in titles and descriptions
- New field types: Horizontal lines and Radio buttons
- Unique submission IDs and IP address logging
- Form change logging system with history viewer
- Customizable form titles and descriptions

## Security

- BCrypt/Argon2 password hashing
- Session-based authentication
- CSRF protection
- XSS prevention through input sanitization
- Share token security for private pages
- Rate limiting on form submissions

## Theme

BookGram features a custom IBM OS/2 Warp 3 inspired theme with:
- Teal background (#008080)
- Silver window panels (#c0c0c0)
- 3D inset/outset borders
- System font styling
- Movable desktop icons
- Retro UI elements

## Browser Support

- Modern browsers (Chrome, Firefox, Safari, Edge)
- Internet Explorer 11+ (limited support)
- Mobile browsers (iOS Safari, Chrome Mobile)

## License

See LICENSE file for details.

## Credits

- **Parsedown** - Markdown parser
- **SortableJS** - Drag-and-drop functionality
- Inspired by IBM OS/2 Warp 3 design language

## Support

For issues, feature requests, or contributions, please contact the development team.

## Changelog

For a detailed list of changes in each version, see [CHANGELOG.md](CHANGELOG.md).

---

**BookGram** - Where retro meets modern. 📚✨
