# Changelog

All notable changes to Bookgram will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [10.02.0] - 2025-12-20

### Added - ChatGram Plugin
- **Session-Based Authentication Fallback**
  - Added fallback authentication that checks `$_SESSION['bookgram_user']` directly
  - Ensures logged-in users are detected even if core functions don't work
  - Username detection fallback to session data
  - Role detection fallback to `$_SESSION['bookgram_role']`

- **Unicode Avatar Support**
  - Replaced missing avatar images with Unicode symbol (👤)
  - Added CSS styling for default avatars matching regular avatar dimensions
  - Eliminates 404 errors from missing avatar files

- **Enhanced Debug Logging**
  - Server-side logging in `heartbeat.php` and `post.php`
  - Client-side console logging for authentication status
  - Debug information in API responses showing session data

### Added - JoinGram Plugin
- **Markdown Rendering Support**
  - Title and Description fields now support markdown formatting
  - Converts `**bold**` to bold text
  - Converts `*italic*` to italic text
  - Automatically converts URLs to clickable hyperlinks opening in new window
  - Converts newlines to `<br>` tags

- **New Form Field Types**
  - **Horizontal Line (HR)**: Visual divider with no configuration needed
  - **Radio Buttons**: Single-choice selection field with custom options

- **Enhanced Submission Tracking**
  - Unique submission ID generated for each response: `sub_[random]_[timestamp]`
  - IP address logging with proxy header support (X-Forwarded-For, HTTP_CLIENT_IP)
  - Both displayed in responses table and CSV export

- **Form Change Logging System**
  - Automatic change tracking when form is saved
  - Logs: Change ID, timestamp, user, field count changes, summary
  - Stores up to 100 most recent changes in `change_log.json`
  - New "Change Log" admin page showing detailed modification history
  - Tracks who changed what and when

- **Customizable Form Title and Description**
  - New "Form Configuration" section in Dashboard
  - Admin/Editors can customize form title and description
  - Configuration stored per instance in `config.json`
  - Replaced static "Recruitment Board" with user-defined titles

### Changed - ChatGram Plugin
- **Authentication Flow**
  - `heartbeat.php` now checks session directly if `is_logged_in()` returns false
  - `post.php` uses same session fallback mechanism
  - Defensive function existence checks before calling core functions

- **API Responses**
  - Heartbeat and post endpoints now include debug information
  - Debug data shows authentication status and session values

### Changed - JoinGram Plugin
- **Admin Interface Updates**
  - Responses table now shows Submission ID and IP Address as first columns
  - CSV export includes new submission ID and IP fields
  - Sidebar navigation includes new "Change Log" link
  - Dashboard includes form configuration editor

- **Default Values**
  - Changed all default titles from "Recruitment Board" to "Application Form"
  - Changed button text from "Submit Application" to "Submit Form"
  - Updated in `setup.php`, `embed.php`, `index.php`, and `dashboard.php`

### Fixed - ChatGram Plugin
- **Guest vs Logged-in User Detection**
  - Fixed issue where admin users were treated as guests
  - Heartbeat now properly detects logged-in users via session fallback
  - Messages from admins now show with correct user type and role
  - Admin/Editor users now appear in online user list

- **Avatar Display Issues**
  - Fixed 404 errors from missing default avatar files
  - Avatar fallback now uses Unicode symbol with proper styling

- **JSON Response Integrity**
  - Added output buffering to prevent stray output breaking JSON
  - Error suppression to ensure clean API responses
  - Try-catch wrappers around all API endpoints

### Technical Details - ChatGram

#### Authentication Implementation
- Session fallback pattern:
  ```php
  $is_logged_in = function_exists('is_logged_in') ? is_logged_in() : false;
  if (!$is_logged_in && isset($_SESSION['bookgram_user'])) {
      $is_logged_in = true;
  }
  ```

- Username retrieval:
  ```php
  $user_id = function_exists('get_current_username') ? get_current_username() : null;
  if (!$user_id && isset($_SESSION['bookgram_user'])) {
      $user_id = $_SESSION['bookgram_user'];
  }
  ```

#### File Locations Modified
```
/plugin_chatgram/api/heartbeat.php    - Session fallback authentication
/plugin_chatgram/api/post.php         - Session fallback authentication
/plugin_chatgram/js/chatgram.js       - Unicode avatar support, debug logging
/plugin_chatgram/css/chatgram.css     - Default avatar styling
```

### Technical Details - JoinGram

#### Markdown Processing Function
```php
function process_markdown($text) {
    // Bold, italic, URLs, line breaks
    return $processed_text;
}
```

#### Unique ID Generation
```php
$submission_id = 'sub_' . bin2hex(random_bytes(8)) . '_' . time();
```

#### Change Log Entry Structure
```json
{
  "change_id": "chg_abc123",
  "timestamp": "2025-12-20 10:30:00",
  "user": "admin",
  "old_field_count": 5,
  "new_field_count": 7,
  "changes_summary": "Added 2 fields (5 → 7)"
}
```

#### File Locations Modified
```
/plugin_joingram/admin/form-builder.php  - HR/Radio fields, change logging
/plugin_joingram/admin/dashboard.php     - Form configuration editor
/plugin_joingram/admin/changelog.php     - Change log viewer (NEW)
/plugin_joingram/admin/responses.php     - Submission ID and IP columns
/plugin_joingram/admin/download.php      - CSV export with new fields
/plugin_joingram/admin/_sidebar.php      - Change Log navigation link
/plugin_joingram/embed.php               - Markdown rendering, HR/Radio rendering
/plugin_joingram/submit.php              - Unique ID and IP logging
/plugin_joingram/index.php               - Updated defaults
/plugin_joingram/setup.php               - Updated defaults
```

### Backward Compatibility
- ChatGram fully compatible with existing installations
- JoinGram existing submissions work without submission_id and ip_address fields (display as "N/A")
- Existing forms work with new field types
- Form configurations created before this version will use default titles

---

## [2.08.0] - 2025-11-15

### Added
- **Optional Password Protection for Private Articles**
  - New optional password field for private pages as an additional security layer
  - Password input field in article editor (`templates/edit.php:71-91`)
  - Password protection works in conjunction with share tokens
  - Visitors need BOTH the share link AND correct password to access protected pages
  - Authors and admins can view their own private pages without password
  - Password prompt template for guest authentication (`templates/password-prompt.php`)
  - New `/verify-password` route for password verification (`index.php:161-197`)
  - Session-based password authentication (stays authenticated for the session)
  - Password removal option in editor interface

- **Navigation Enhancement**
  - "Back to Folder" button on article pages (`templates/page.php:81`)
  - Returns user to the current folder/directory level
  - Positioned on left side of page actions bar
  - Automatically calculates parent folder from article path
  - Returns to root browser if article is at top level

### Changed
- **Data Model Updates**
  - Page JSON schema now includes:
    - `password_hash` (string) - BCrypt/Argon2 hash of the optional password
  - Updated `save_page_content()` function signature to accept `$password` parameter (`app/core/functions.php:367`)
  - Enhanced `can_view_private_page()` to check password authentication (`app/core/functions.php:199-238`)
  - Added `verify_page_password()` function for secure password verification (`app/core/functions.php:246-267`)

### Fixed
- **Code Block Rendering**
  - Fixed `strip_tags()` to allow `<pre>` tags (`templates/page.php:27`)
  - Code blocks with ``` and ~~~ now properly preserve line breaks
  - Previously `<pre>` tags were being stripped, causing code to concatenate on one line
  - CSS styling from v2.07 now works correctly with allowed `<pre>` tags
  - Changed `white-space: pre` to `white-space: pre-wrap` for responsive wrapping (`public/css/style.css:244`)
  - Added `word-wrap: break-word` and `max-width: 100%` to prevent code blocks from breaking page layout
  - Long lines now wrap within boundaries while preserving intentional line breaks
  - Horizontal scrolling still available for very long unbreakable tokens

- **User Experience Improvements**
  - Password prompt shown automatically when accessing password-protected pages
  - Clear error messages on incorrect password attempts
  - Visual indicators show when password protection is enabled (🔒 icon with text)
  - Authors see password status in both edit and view modes
  - Inline JavaScript toggle for password field visibility in editor

### Security
- **Password Hashing**
  - Passwords hashed using PHP's `password_hash()` with PASSWORD_DEFAULT (currently Argon2id or BCrypt)
  - Password verification uses `password_verify()` to prevent timing attacks
  - Passwords never stored in plaintext
  - Session-based authentication prevents repeated password entry
  - CSRF protection on password submission

- **Access Control Flow**
  1. Check if page is private
  2. Check if user is author/admin (bypass all checks)
  3. Verify share token is valid
  4. If password is set, verify password via session or prompt
  5. Grant access only if all conditions met

### Technical Details

#### Password Protection Implementation
- Password field is optional - private pages can have token-only or token+password protection
- Passwords are hashed immediately upon save
- Empty password field preserves existing password
- "Remove password" checkbox explicitly clears password protection
- Password verification stores authentication in `$_SESSION['authenticated_pages']` array

#### File Locations Modified
```
/app/core/functions.php        - Password hashing and verification functions
/templates/edit.php            - Password input field with toggle (lines 71-103)
/templates/page.php            - Password protection indicators (lines 45-56)
/templates/password-prompt.php - Password entry form (NEW)
/index.php                     - Password handling in save and verify routes
/CHANGELOG.md                  - This file (UPDATED)
/VERSION.txt                   - Version number update
```

#### Database Schema Changes
For existing pages, the password field will be automatically initialized:
- `password_hash`: `''` (empty string = no password)

### Backward Compatibility
- Fully backward compatible with v2.07
- Existing private pages without passwords continue to work with token-only access
- Public pages unaffected
- No data migration required

### Usage Example

**Setting up a password-protected page:**
1. Edit or create a page
2. Check "Make this page private"
3. Enter a password in the "Optional Password Protection" field
4. Save the page
5. Copy the share link
6. Share both the link AND password with intended recipients

**Accessing a password-protected page:**
1. Click the share link (includes token in URL)
2. Enter the password when prompted
3. Submit to view the page
4. Password authentication persists for the session

### Known Limitations
- Password authentication is session-based only (no persistent "remember me")
- No password strength requirements enforced
- No password reset mechanism (author must change it manually)
- Session expires when browser is closed
- Multiple failed password attempts are not rate-limited

---

## [2.07.0] - 2025-11-15

### Added
- **Private Articles with Share Links**
  - New privacy control for articles - pages can now be marked as private
  - Private pages are only accessible via a unique, auto-generated share link
  - Privacy checkbox added to article editor (`templates/edit.php:62-68`)
  - Share link display in edit mode for private pages (`templates/edit.php:70-83`)
  - Share link display on page view for authors/admins (`templates/page.php:43-62`)
  - Private pages are hidden from:
    - Directory browser unless viewed by author/admin
    - Search results unless viewed by author/admin
    - RSS feeds unless viewed by author/admin
  - Access control:
    - Authors can always view their own private pages
    - Admins can view all private pages
    - Anyone with the share token URL can view the page
    - 403 Forbidden error for unauthorized access attempts

- **Code Block Rendering Fix**
  - Fixed markdown code blocks to properly preserve line breaks and formatting
  - Added CSS styling for `<pre>` elements with `white-space: pre` (`public/css/style.css:239-254`)
  - Improved monospace font rendering for code blocks
  - Added proper styling for inline code vs. multi-line code blocks
  - Print stylesheet also updated to handle code blocks correctly

### Changed
- **Data Model Updates**
  - Page JSON schema now includes:
    - `is_private` (boolean) - privacy status flag
    - `share_token` (string) - unique 32-character hex token for private access
  - Updated `save_page_content()` function signature to accept `$is_private` parameter (`app/core/functions.php:367`)
  - Privacy settings preserved during page reverts (`app/core/functions.php:891`)

- **Function Enhancements**
  - `get_directory_contents()` - Now filters private pages based on user permissions (`app/core/functions.php:571-574`)
  - `search_pages()` - Excludes private pages from search unless user has permission (`app/core/functions.php:929-932`)
  - `get_all_pages_sorted_by_date()` - Filters private pages from RSS/listings (`app/core/functions.php:990-993`)
  - Added `can_view_private_page()` helper function (`app/core/functions.php:199-226`)
  - Added `generate_share_token()` utility function (`app/core/functions.php:190-192`)

### Technical Details

#### Privacy Implementation
- Share tokens are generated using `bin2hex(random_bytes(16))` for cryptographic security
- Token validation uses `hash_equals()` to prevent timing attacks
- Tokens are automatically generated when a page is first marked private
- Tokens are cleared when a page is made public
- Token parameter passed via URL query string: `?token={32-char-hex}`

#### File Locations Modified
```
/public/css/style.css          - Code block styling (lines 239-254)
/app/core/functions.php        - Privacy functions and data filtering
/templates/edit.php            - Privacy checkbox and share link UI
/templates/page.php            - Private page notice and share link display
/index.php                     - Privacy parameter handling in save route (line 120)
/CHANGELOG.md                  - This file (NEW)
```

#### Database Schema Changes
No database migrations required (file-based storage).

For existing pages, the privacy fields will be automatically initialized to default values:
- `is_private`: `false`
- `share_token`: `''` (empty string)

### Security Notes
- Share tokens are 32 characters (128 bits of entropy)
- Private pages return HTTP 403 for unauthorized access
- Share links do not expire (manual regeneration requires toggling privacy off/on)
- Authors cannot see other authors' private pages without the share link
- Admins have full access to all pages regardless of privacy settings

### Backward Compatibility
- All changes are fully backward compatible with v2.06
- Existing pages will default to public (is_private = false)
- No data migration required
- Pages without privacy fields will be treated as public

### Known Limitations
- Share tokens do not expire and cannot be regenerated without toggling privacy
- No analytics on who accessed a private page via share link
- Private pages still increment view counts when accessed via share link
- No bulk privacy operations available in admin panel

---

## [2.06.0] - Previous Version

Initial release of v2.06 with:
- File-based content management system
- Markdown support via Parsedown
- User authentication (Admin/Editor roles)
- Page revision history
- UUID-based permanent links
- Feature image support
- Directory/folder organization
- Full-text search
- RSS feed
- Profile pages
- Hit tracking (total and unique views)
- Print-friendly styling
- IBM OS/2 Warp 3 retro theme
- Mobile responsive design
- Movable launchpad navigation
