# BookGram Version 8.1

**A lightweight, hierarchical content management system with an IBM OS/2 Warp aesthetic**

## Overview

BookGram is a file-based content management system (CMS) designed for simplicity, efficiency, and ease of use. It features a hierarchical folder-based organization system, complete revision control, and a nostalgic IBM OS/2 Warp 3 themed interface. No database required - all content is stored in simple JSON files, making backups and version control straightforward.

## Key Features

### Content Management
- **Hierarchical File Browser**: Organize content in nested folders like a traditional file system
- **Markdown & HTML Support**: Write using simple Markdown syntax or full HTML
- **Table Support**: Full support for Markdown tables with responsive design
- **Revision History**: Complete version control with ability to view, revert, and delete revisions
- **Feature Images**: Add visual appeal with customizable feature images for pages
- **Private Pages**: Create password-protected pages with secure share links
- **Hashtag System**: Tag content with hashtags for easy categorization and search

### User Management
- **Multi-User Support**: Role-based permissions with three levels:
  - **Admin**: Full system access, user management, settings
  - **Editor**: Create and edit pages, upload images
  - **Viewer**: Read-only access to public content
- **User Profiles**: Personal profiles with avatars, bios, and author pages
- **Session Management**: Secure authentication with "Remember Me" functionality

### Search & Discovery
- **Full-Text Search**: Search across all content with keyword matching
- **Hashtag Search**: Find content by hashtag tags
- **Site Tree**: Visual hierarchical view of entire site structure
- **RSS Feed**: Automatic RSS feed generation for latest content

### Interface & Design
- **OS/2 Warp Theme**: Classic 1990s IBM aesthetic with 3D borders and gradients
- **Movable Launchpad**: Draggable navigation toolbar (desktop)
- **Mobile Responsive**: Fully optimized for smartphones and tablets
- **Print Friendly**: Optimized CSS for printing pages

## System Requirements

### Server Requirements
- **PHP**: 7.4 or higher
- **Web Server**: Apache, Nginx, or similar
- **Storage**: File system access (no database required)
- **Extensions**:
  - `json` (usually enabled by default)
  - `fileinfo` (for image uploads)
  - `session` (for user authentication)

### Recommended
- HTTPS enabled for secure password transmission
- `.htaccess` support (Apache) or equivalent URL rewriting
- 256MB+ PHP memory limit for large file uploads

## Installation & Deployment

### Step 1: Download and Extract
```bash
# Extract BookGram files to your web directory
cd /var/www/html
unzip bookgram-v802.zip
cd shavidica
```

### Step 2: Set Permissions
```bash
# Make storage directories writable
chmod -R 755 app/storage
chmod -R 755 public/uploads

# Ensure PHP can write to these directories
chown -R www-data:www-data app/storage
chown -R www-data:www-data public/uploads
```

### Step 3: Configure Web Server

#### Apache (.htaccess)
BookGram includes an `.htaccess` file for Apache. Ensure `mod_rewrite` is enabled:
```bash
sudo a2enmod rewrite
sudo systemctl restart apache2
```

#### Nginx
Add this to your server block:
```nginx
location / {
    try_files $uri $uri/ /index.php?$query_string;
}

location ~ \.php$ {
    fastcgi_pass unix:/var/run/php/php7.4-fpm.sock;
    fastcgi_index index.php;
    include fastcgi_params;
    fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
}
```

### Step 4: Run Setup
Navigate to your BookGram installation in a web browser:
```
http://yourdomain.com/setup.php
```

Follow the on-screen instructions to:
1. Create the first admin user
2. Set site title and description
3. Configure basic settings

### Step 5: Remove Setup File
After setup is complete:
```bash
rm setup.php
```

### Step 6: Login
Navigate to `/login` and use your admin credentials to access the system.

## Directory Structure

```
bookgram/
├── app/
│   ├── core/
│   │   ├── auth.php           # Authentication & user management
│   │   ├── functions.php      # Core CMS functions
│   │   └── Parsedown.php      # Markdown parser
│   └── storage/
│       ├── pages/             # Content files (JSON)
│       ├── revisions/         # Revision history (TXT)
│       ├── users.json         # User accounts
│       ├── config.json        # Site configuration
│       └── uuid_index.json    # UUID to path mapping
├── public/
│   ├── css/
│   │   ├── style.css          # Main stylesheet
│   │   └── print.css          # Print styles
│   ├── js/
│   │   └── main.js            # JavaScript utilities
│   └── uploads/               # User-uploaded images
├── templates/
│   ├── partials/
│   │   ├── header.php         # Site header
│   │   └── footer.php         # Site footer
│   ├── browser.php            # Folder browser view
│   ├── page.php               # Page display
│   ├── edit.php               # Page editor
│   ├── profile.php            # User profile
│   └── ...                    # Other templates
├── index.php                  # Main router
└── README.md                  # Quick start guide
```

## Basic Usage

### Creating Content

1. **Navigate to a folder** using the folder browser (home page)
2. Click **"Create New Page Here"** button
3. Fill in:
   - **Page Title**: The display name
   - **Filename (slug)**: URL-friendly name (auto-generated if blank)
   - **Feature Image**: Optional image URL or upload
   - **Content**: Write using Markdown or HTML
4. Click **"Save Changes"**

### Organizing Content

1. **Create Folders**: Use the admin form at the bottom of any folder view
2. **Move Items**: Click the "M" button next to any page/folder
3. **Rename Items**: Click the "R" button next to any page/folder
4. **Delete Items**: Click the "D" button (admin only)

### Markdown Syntax Examples

```markdown
# Heading 1
## Heading 2

**Bold text** and *italic text*

- Bullet point 1
- Bullet point 2

1. Numbered item
2. Numbered item

[Link text](http://example.com)

![Image alt text](http://example.com/image.png)

| Header 1 | Header 2 | Header 3 |
|----------|----------|----------|
| Cell 1   | Cell 2   | Cell 3   |
| Cell 4   | Cell 5   | Cell 6   |

#hashtag #another-tag
```

### Using Hashtags

Add hashtags anywhere in your content:
```
This page is about #documentation and #tutorials
```

Search for hashtags by clicking them or searching: `#documentation`

### Creating Private Pages

1. Edit or create a page
2. Check **"Make this page private"**
3. Optionally set a password
4. Save the page
5. Copy the share link from the edit page
6. Share the link (and password if set) with authorized users

### Revision History

Every time you save a page, a new revision is created. To:
- **View old revision**: Click the timestamp in the revision history
- **Revert to old revision**: Click "Revert" (admin only)
- **Delete old revision**: Click "D" next to the revision (admin only)

## Use Case Scenarios

### 1. Personal Knowledge Base
**Scenario**: Individual wants to organize personal notes, research, and documentation.

**Setup**:
- Single user (admin account)
- Organize by topic: `/Technology/`, `/Health/`, `/Finance/`, etc.
- Use hashtags for cross-referencing topics
- Use private pages for sensitive information

**Benefits**:
- No database complexity
- Easy to backup (just copy files)
- Full-text search across all notes
- Revision history tracks changes over time

---

### 2. Team Documentation Portal
**Scenario**: Small team needs to collaborate on internal documentation.

**Setup**:
- Multiple users: admins and editors
- Organize by department: `/Engineering/`, `/Marketing/`, `/HR/`
- Use feature images for visual identification
- Regular content creation and updates

**Benefits**:
- Role-based access control
- Track who created/edited what
- No per-user licensing costs
- Easy to deploy on internal server

---

### 3. Project Management Hub
**Scenario**: Managing multiple projects with notes, plans, and documentation.

**Setup**:
```
/Projects/
  ├── Project-Alpha/
  │   ├── planning-notes
  │   ├── requirements
  │   └── meeting-minutes
  ├── Project-Beta/
  │   ├── design-docs
  │   └── implementation-plan
  └── Archive/
```

**Benefits**:
- Visual folder hierarchy
- Site tree shows all projects at a glance
- Hashtags link related content across projects
- Revision history preserves project evolution

---

### 4. Educational Content Platform
**Scenario**: Teacher creating course materials and resources for students.

**Setup**:
```
/Courses/
  ├── Math-101/
  │   ├── Syllabus
  │   ├── Lectures/
  │   ├── Assignments/
  │   └── Resources/
  └── Math-102/
```

**Usage**:
- Public pages for course materials
- Private pages for answer keys (password-protected)
- Share links for specific student groups
- Tables for grade scales, schedules, etc.

**Benefits**:
- Easy to navigate course structure
- Print-friendly for handouts
- Mobile-friendly for student access
- No complicated LMS setup

---

### 5. Portfolio Website
**Scenario**: Creative professional showcasing work samples.

**Setup**:
```
/Portfolio/
  ├── Web-Design/
  ├── Graphic-Design/
  ├── Photography/
  └── About-Me
```

**Usage**:
- Feature images for each project
- Rich markdown for project descriptions
- Tables for project details (client, date, tools)
- Hashtags for skills/technologies

**Benefits**:
- Professional appearance
- Easy to update projects
- RSS feed for new work announcements
- Complete control over content

---

### 6. Research Repository
**Scenario**: Researcher organizing papers, notes, and data.

**Setup**:
- Folders by research topic or date
- Use hashtags for methodology, subjects, findings
- Link related papers using UUID links
- Tables for data summaries

**Benefits**:
- Full-text search across all notes
- Revision history tracks research progress
- Easy citation with page IDs
- Backup-friendly file structure

---

### 7. Small Business Website
**Scenario**: Local business needs simple content website.

**Setup**:
```
/
├── About-Us
├── Services/
│   ├── Service-1
│   └── Service-2
├── Contact
└── Blog/
```

**Benefits**:
- No monthly CMS fees
- Easy for staff to update
- Mobile-responsive design
- RSS feed for blog posts

---

### 8. Family Wiki
**Scenario**: Family documenting history, recipes, and shared information.

**Setup**:
- Private site on home server
- Folders for: Recipes, History, Photos, Events
- Multiple family members with editor access
- Password-protected private family information

**Benefits**:
- Collaborative family documentation
- Revision history preserves old versions
- Simple enough for non-technical family members
- Print recipes and documents easily

## Advanced Features

### UUID Linking
Create permanent links between pages using UUIDs:
```markdown
See also: [Related Page](uuid:Projects_example-page)
```

The UUID is shown at the bottom of each page. These links remain valid even if pages are moved or renamed.

### Custom Styling
Edit `/public/css/style.css` to customize the appearance. The OS/2 theme variables:
- Window background: `#c0c0c0`
- Title bar gradient: `#400040` to `#600060`
- Body background: `#008080` (teal)
- Link colors: Navy blue, red (visited), light blue (hover)

### Footer Customization
Admins can add custom HTML to the footer via Admin Panel → Settings → Footer Prefix.

### Image Management
Images uploaded via the page editor are stored in:
- Feature images: `/public/uploads/features/`
- Profile photos: `/public/uploads/avatars/`

## Backup & Maintenance

### Backing Up
Simple backup process - copy these directories:
```bash
# Backup all content and configuration
tar -czf bookgram-backup-$(date +%Y%m%d).tar.gz \
  app/storage/ \
  public/uploads/
```

### Restoring
```bash
# Extract backup
tar -xzf bookgram-backup-20250101.tar.gz

# Restore permissions
chmod -R 755 app/storage public/uploads
chown -R www-data:www-data app/storage public/uploads
```

### Updates
1. Backup current installation
2. Replace core files (`index.php`, `app/core/*`, `templates/*`)
3. Keep `app/storage/` and `public/uploads/` intact
4. Test functionality

## Security Considerations

### Best Practices
1. **Use HTTPS**: Encrypt password transmission
2. **Strong Passwords**: Enforce strong admin passwords
3. **Regular Backups**: Automated daily backups recommended
4. **File Permissions**: Storage directories should not be directly web-accessible
5. **Remove Setup**: Delete `setup.php` after installation
6. **Update PHP**: Keep PHP version current with security patches

### Private Pages
- Share tokens are cryptographically secure random strings
- Passwords are hashed using PHP's `password_hash()` (bcrypt)
- Private pages are not indexed or listed publicly

## Troubleshooting

### Common Issues

**Problem**: "Permission denied" errors
```bash
# Solution: Fix permissions
chmod -R 755 app/storage public/uploads
chown -R www-data:www-data app/storage public/uploads
```

**Problem**: URLs not working (404 errors)
```bash
# Apache: Enable mod_rewrite
sudo a2enmod rewrite
sudo systemctl restart apache2

# Check .htaccess exists
ls -la .htaccess
```

**Problem**: Images not uploading
```bash
# Check PHP upload limits in php.ini
upload_max_filesize = 10M
post_max_size = 10M

# Restart web server after changes
sudo systemctl restart apache2
```

**Problem**: Tables not rendering
- Ensure table tags are allowed in `templates/page.php` line 27
- Check CSS is loading properly
- View page source to see if table HTML is present

## Technical Specifications

- **Backend**: PHP 7.4+
- **Storage**: File-based (JSON for data, TXT for revisions)
- **Frontend**: HTML5, CSS3, Vanilla JavaScript
- **Parser**: Parsedown 1.8.0 (Markdown to HTML)
- **Security**: CSRF protection, password hashing (bcrypt), session management
- **Theme**: IBM OS/2 Warp 3 inspired
- **License**: Copyright to respective users
- **Version**: 8.1 (v802)

## Support & Contact

For sales inquiries, licensing, custom development, or technical support:

**Email**: jsp@pagetelegram.com

## Credits

- **Markdown Parser**: Parsedown by Emanuil Rusev
- **Theme Inspiration**: IBM OS/2 Warp 3
- **Development**: BookGram Team

---

**BookGram Version 8.1** - Simple. Hierarchical. Nostalgic.
