/*
 * Decompiled with CFR 0.152.
 */
package com.ytgram.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class Settings {
    private static final String CONFIG_FILE = System.getProperty("user.home") + "/.ytgram.properties";
    private Properties properties = new Properties();

    public Settings() {
        this.load();
    }

    public void load() {
        File file = new File(CONFIG_FILE);
        if (file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                this.properties.load(fileInputStream);
            }
            catch (IOException iOException) {
                System.err.println("Error loading settings: " + iOException.getMessage());
            }
        } else {
            this.setDefaults();
        }
    }

    public void save() {
        try (FileOutputStream fileOutputStream = new FileOutputStream(CONFIG_FILE);){
            this.properties.store(fileOutputStream, "ytgram Configuration");
        }
        catch (IOException iOException) {
            System.err.println("Error saving settings: " + iOException.getMessage());
        }
    }

    private void setDefaults() {
        this.properties.setProperty("download.directory", System.getProperty("user.home") + "/Downloads");
        this.properties.setProperty("clipboard.enabled", "false");
        this.properties.setProperty("default.format", "mp3");
    }

    public String getDownloadDirectory() {
        return this.properties.getProperty("download.directory", System.getProperty("user.home") + "/Downloads");
    }

    public void setDownloadDirectory(String string) {
        this.properties.setProperty("download.directory", string);
        this.save();
    }

    public boolean isClipboardEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty("clipboard.enabled", "false"));
    }

    public void setClipboardEnabled(boolean bl) {
        this.properties.setProperty("clipboard.enabled", String.valueOf(bl));
        this.save();
    }

    public String getDefaultFormat() {
        return this.properties.getProperty("default.format", "mp3");
    }

    public void setDefaultFormat(String string) {
        this.properties.setProperty("default.format", string);
        this.save();
    }
}

