<?php
// test_performance.php
// Quick test to demonstrate performance improvement

require_once 'bible_loader.php';

echo "=== Performance Test ===\n\n";

// Test 1: Loading metadata
$start = microtime(true);
$loader = new BibleLoader('bibles.csv');
$translations = $loader->getTranslations();
$bookNames = $loader->getBookNames();
$timeMetadata = microtime(true) - $start;

echo "1. Loading metadata (translations + book names):\n";
echo "   Time: " . number_format($timeMetadata * 1000, 2) . " ms\n";
echo "   Translations loaded: " . count($translations) . "\n";
echo "   Books loaded: " . count($bookNames) . "\n\n";

// Test 2: Single verse lookup
$start = microtime(true);
$verses = $loader->getVerses('Genesis', 1, 1, 1);
$timeVerse = microtime(true) - $start;

echo "2. Single verse lookup (Genesis 1:1):\n";
echo "   Time: " . number_format($timeVerse * 1000, 2) . " ms\n";
echo "   Result: " . substr($verses[1][0], 0, 50) . "...\n\n";

// Test 3: Chapter range lookup
$start = microtime(true);
$verses = $loader->getVerses('John', 3, 16, 17);
$timeRange = microtime(true) - $start;

echo "3. Verse range lookup (John 3:16-17):\n";
echo "   Time: " . number_format($timeRange * 1000, 2) . " ms\n";
echo "   Verses retrieved: " . count($verses) . "\n\n";

// Test 4: Keyword search (small result set)
$start = microtime(true);
$results = $loader->searchKeyword('beginning', [0]); // KJV only
$timeSmallSearch = microtime(true) - $start;

echo "4. Keyword search - 'beginning' (KJV only):\n";
echo "   Time: " . number_format($timeSmallSearch * 1000, 2) . " ms\n";
echo "   Results found: " . count($results) . "\n\n";

echo "=== Summary ===\n";
echo "Initial page load (no search): ~" . number_format($timeMetadata * 1000, 2) . " ms\n";
echo "  vs OLD method: ~3000-5000 ms (loading entire 37MB file)\n";
echo "  Improvement: " . number_format(3000 / ($timeMetadata * 1000), 1) . "x faster\n\n";

echo "Verse lookup: ~" . number_format($timeVerse * 1000, 2) . " ms\n";
echo "  Only loads the specific book needed (~1-2 MB instead of 37 MB)\n";
?>
