<?php
// changelog.php
// Public changelog for Bib by Amfile.org
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Changelog - Bib 4.0 by Amfile.org</title>
    <meta name="description" content="Version history and changelog for Bib, the Bible search and study tool by Amfile.org">

    <?php
    // Detect protocol (fix for when REQUEST_SCHEME is not set)
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ||
                (!empty($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == 443) ||
                (!empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https') ||
                (!empty($_SERVER['REQUEST_SCHEME']) && $_SERVER['REQUEST_SCHEME'] === 'https')
                ? 'https' : 'http';
    $baseUrl = $protocol . '://' . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/');
    $currentUrl = $protocol . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    $ogImageUrl = $baseUrl . '/logo-og.jpg?v=' . filemtime(__DIR__ . '/logo-og.jpg');
    ?>
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo htmlspecialchars($currentUrl); ?>">
    <meta property="og:title" content="Changelog - Bib 4.0 by Amfile.org">
    <meta property="og:description" content="Version history and updates for Bib Bible search tool">
    <meta property="og:image" content="<?php echo htmlspecialchars($ogImageUrl); ?>">
    <meta property="og:image:secure_url" content="<?php echo htmlspecialchars(str_replace('http://', 'https://', $ogImageUrl)); ?>">
    <meta property="og:image:width" content="815">
    <meta property="og:image:height" content="510">
    <meta property="og:image:type" content="image/jpeg">
    <meta property="og:image:alt" content="Bib 4.0 - Bible Search Tool Logo">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo htmlspecialchars($currentUrl); ?>">
    <meta property="twitter:title" content="Changelog - Bib 4.0 by Amfile.org">
    <meta property="twitter:description" content="Version history and updates for Bib Bible search tool">
    <meta property="twitter:image" content="<?php echo htmlspecialchars($ogImageUrl); ?>">

    <link rel="stylesheet" href="styles.css">
    <style>
        .changelog-container {
            max-width: 900px;
            margin: 2rem auto;
            padding: 0 1rem;
        }

        .version-section {
            margin-bottom: 3rem;
            padding: 2rem;
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        .version-header {
            display: flex;
            align-items: baseline;
            gap: 1rem;
            margin-bottom: 1rem;
            padding-bottom: 0.5rem;
            border-bottom: 2px solid var(--os2-purple);
        }

        .version-number {
            font-size: 2rem;
            font-weight: bold;
            color: var(--os2-purple);
        }

        .version-date {
            color: #666;
            font-size: 0.95rem;
        }

        .version-badge {
            display: inline-block;
            padding: 0.25rem 0.75rem;
            background: var(--os2-purple);
            color: white;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: bold;
        }

        .changelog-category {
            margin: 1.5rem 0;
        }

        .changelog-category h3 {
            color: var(--os2-purple);
            font-size: 1.2rem;
            margin-bottom: 0.75rem;
        }

        .changelog-category ul {
            margin: 0;
            padding-left: 1.5rem;
        }

        .changelog-category li {
            margin: 0.5rem 0;
            line-height: 1.6;
        }

        .performance-stat {
            display: inline-block;
            padding: 0.25rem 0.5rem;
            background: #e8f5e9;
            color: #2e7d32;
            border-radius: 4px;
            font-weight: bold;
            font-family: monospace;
        }

        .code-snippet {
            background: #f5f5f5;
            padding: 0.25rem 0.5rem;
            border-radius: 3px;
            font-family: monospace;
            font-size: 0.9rem;
        }

        .back-link {
            display: inline-block;
            margin: 1rem 0.5rem;
            padding: 0.75rem 1.5rem;
            background: var(--os2-purple);
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            transition: background 0.3s;
        }

        .back-link:hover {
            background: #5a1f66;
        }

        @media (max-width: 768px) {
            .version-header {
                flex-direction: column;
                gap: 0.5rem;
            }

            .version-number {
                font-size: 1.5rem;
            }

            .version-section {
                padding: 1rem;
            }
        }
    </style>
</head>
<body>
    <h1>Changelog - <a href="index.php" class="header-link">Bib 4.0</a></h1>

    <a href="index.php" class="back-link">← Back to Bib</a>

    <div class="changelog-container">

        <!-- Version 4.0 -->
        <div class="version-section">
            <div class="version-header">
                <span class="version-number">Version 4.0</span>
                <span class="version-badge">LATEST</span>
                <span class="version-date">November 21, 2025</span>
            </div>

            <div class="changelog-category">
                <h3>🚀 Major Performance Optimization</h3>
                <ul>
                    <li><strong>Initial page load:</strong> <span class="performance-stat">2,196x faster</span> (from ~3000ms to ~1.4ms)</li>
                    <li><strong>Memory usage:</strong> Reduced from 37MB to ~2KB on page load</li>
                    <li>Implemented indexed data loading system to avoid reading entire Bible file on every request</li>
                    <li>Created pre-generated index files that split Bible data by individual books</li>
                    <li>Page now loads only metadata (translations + book names) initially</li>
                    <li>Lazy-loads specific book data only when performing searches</li>
                    <li>Keyword searches load books one at a time to minimize memory footprint</li>
                </ul>
            </div>

            <div class="changelog-category">
                <h3>🐛 Bug Fixes</h3>
                <ul>
                    <li>Fixed UTF-8 encoding issues that prevented some books (like Exodus) from being properly indexed</li>
                    <li>Implemented proper handling of malformed UTF-8 characters in source data</li>
                </ul>
            </div>

            <div class="changelog-category">
                <h3>🔧 Technical Changes</h3>
                <ul>
                    <li>Added <span class="code-snippet">bible_loader.php</span> - Efficient data loading class</li>
                    <li>Added <span class="code-snippet">generate_indexes.php</span> - Index generation script</li>
                    <li>Created <span class="code-snippet">bible_index/</span> directory with 51 index files (~30MB total)</li>
                    <li>Modified core loading mechanism to use indexed system instead of full file parsing</li>
                    <li>Verse lookups now load only 1-2MB per book instead of entire 37MB file</li>
                    <li>No breaking changes to functionality, URLs, or user interface</li>
                </ul>
            </div>

            <div class="changelog-category">
                <h3>📊 Performance Comparison</h3>
                <ul>
                    <li><strong>Old method:</strong> Read entire 37MB file on every page load</li>
                    <li><strong>New method:</strong> Read ~2KB of metadata, load books only when needed</li>
                    <li><strong>Result:</strong> Nearly instant page loads and dramatically reduced server load</li>
                </ul>
            </div>
        </div>

        <!-- Version 3.5 -->
        <div class="version-section">
            <div class="version-header">
                <span class="version-number">Version 3.5</span>
                <span class="version-date">November 2025</span>
            </div>

            <div class="changelog-category">
                <h3>✨ Features</h3>
                <ul>
                    <li>Bible verse lookup with configurable context verses (before/after)</li>
                    <li>Keyword search across all translations</li>
                    <li>Support for 10 Bible translations:
                        <ul>
                            <li>King James Bible (KJV)</li>
                            <li>American Standard Version (ASV)</li>
                            <li>Douay-Rheims Bible (DRB)</li>
                            <li>Darby Bible Translation (DBT)</li>
                            <li>English Revised Version (ERV)</li>
                            <li>Webster Bible Translation (WBT)</li>
                            <li>World English Bible (WEB)</li>
                            <li>Young's Literal Translation (YLT)</li>
                            <li>American King James Version (AKJ)</li>
                            <li>Weymouth New Testament (WNT)</li>
                        </ul>
                    </li>
                    <li>Floating study notes panel with drag-and-drop repositioning</li>
                    <li>Save notes to server anonymously</li>
                    <li>Download notes as text files</li>
                    <li>View saved notes from other users</li>
                    <li>CSV export functionality for search results</li>
                    <li>URL sharing for specific searches</li>
                    <li>Client-side result filtering</li>
                    <li>Usage statistics tracking (total hits, human hits, searches)</li>
                    <li>Bot detection for accurate analytics</li>
                </ul>
            </div>

            <div class="changelog-category">
                <h3>🎨 User Interface</h3>
                <ul>
                    <li>Clean, modern interface with purple accent colors</li>
                    <li>Responsive design for mobile and desktop</li>
                    <li>Toggle between verse lookup and keyword search modes</li>
                    <li>Translation abbreviations for easier selection</li>
                    <li>Real-time result count with filtering</li>
                </ul>
            </div>
        </div>

        <!-- Future Plans -->
        <div class="version-section" style="background: #f8f9fa; border-left: 4px solid var(--os2-purple);">
            <div class="version-header">
                <span class="version-number">Future Plans</span>
            </div>
            <div class="changelog-category">
                <h3>Potential Future Enhancements</h3>
                <ul>
                    <li>Advanced search operators (AND, OR, NOT)</li>
                    <li>Verse comparison view across translations</li>
                    <li>Reading plans</li>
                    <li>Bookmarking system</li>
                    <li>Dark mode</li>
                </ul>
            </div>
        </div>

    </div>

    <div style="text-align: center; margin: 3rem 0; padding: 2rem 1rem; background: white; border-radius: 8px;">
        <h2>About Bib</h2>
        <p style="max-width: 600px; margin: 1rem auto; line-height: 1.8;">
            Bib is a free, fast, and easy-to-use Bible search tool created by
            <a href="https://amfile.org" target="_blank" rel="noopener noreferrer" style="color: var(--os2-purple); font-weight: bold;">Amfile.org</a>.
            Search across 10 Bible translations, save study notes, and share verses with ease.
        </p>
        <a href="index.php" class="back-link">Start Searching →</a>
    </div>

</body>
</html>
