# Changelog

## Version 4.0 (2025-11-21)

### Major Performance Optimization
- **2,196x faster initial page load** (from ~3000ms to ~1.4ms)
- Implemented indexed data loading system to avoid reading entire 37MB file on every page load
- Created pre-generated index files that split bible data by book
- Only loads metadata (translations + book names) on initial page load
- Lazy-loads specific book data only when performing searches

### New Files
- `generate_indexes.php` - Script to generate index files from bible data
- `bible_loader.php` - Efficient data loading class
- `bible_index/` - Directory containing 51 index files (~29MB total)
- `test_performance.php` - Performance testing and comparison script
- `PERFORMANCE_OPTIMIZATION.md` - Detailed documentation

### Bug Fixes
- Fixed UTF-8 encoding issues that were preventing some books (like Exodus) from being properly indexed
- Used `JSON_INVALID_UTF8_SUBSTITUTE` flag to handle malformed UTF-8 characters

### Setup Required
Run `php generate_indexes.php` once to generate the index files before using version 4.0

### Technical Changes
- Modified `index.php` lines 95-136 to use BibleLoader class instead of loading entire file
- Verse lookups now load only 1-2MB per book instead of entire 37MB file
- Keyword searches load books sequentially to reduce memory usage
- No breaking changes to functionality, URLs, or user interface

---

## Version 3.5 (Previous)
- Bible verse lookup with context verses
- Keyword search across all translations
- 10 Bible translations support
- Study notes with server saving
- CSV export functionality
- URL sharing
